/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.po.promotion;

import com.depotnearby.common.po.promotion.ChargePromotionPolicy;
import com.depotnearby.util.StringTool;
import java.io.Serializable;
import java.util.List;

public class ChargeStepPromotionPolicy
extends ChargePromotionPolicy {
    private static final long serialVersionUID = -1068686755119007915L;
    private List<Step> stepList;

    public List<Step> getStepList() {
        return this.stepList;
    }

    public void setStepList(List<Step> stepList) {
        this.stepList = stepList;
    }

    @Override
    public int calculateFreeOfCharge(int amount) {
        int max = 0;
        if (this.stepList != null) {
            for (Step step : this.stepList) {
                max = Math.max(max, step.calculateFreeOfCharge(amount));
            }
        }
        return max;
    }

    @Override
    public String getInfo() {
        StringBuilder sb = new StringBuilder();
        if (this.stepList != null && this.stepList.size() > 0) {
            for (Step step : this.stepList) {
                sb.append(step.info()).append(",");
            }
            sb.deleteCharAt(sb.lastIndexOf(","));
        }
        return sb.toString();
    }

    @Override
    public String freeInfo(int amount) {
        int max = 0;
        Step s = null;
        if (this.stepList != null) {
            for (Step step : this.stepList) {
                if (step.calculateFreeOfCharge(amount) <= max) continue;
                s = step;
            }
        }
        if (s != null) {
            return s.info();
        }
        return null;
    }

    public static class Step
    implements Serializable {
        private static final long serialVersionUID = 364641898859043293L;
        private Integer cost;
        private Integer free;

        public Step() {
        }

        public Step(Integer cost, Integer free) {
            this.cost = cost;
            this.free = free;
        }

        public Integer getCost() {
            return this.cost;
        }

        public void setCost(Integer cost) {
            this.cost = cost;
        }

        public Integer getFree() {
            return this.free;
        }

        public void setFree(Integer free) {
            this.free = free;
        }

        public int calculateFreeOfCharge(int amount) {
            return amount >= this.cost ? this.free : 0;
        }

        public String info() {
            return "\u6ee1" + StringTool.formatPriceToYun((double)this.cost.intValue()) + "\u51cf" + StringTool.formatPriceToYun((double)this.free.intValue());
        }
    }
}

