/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.po.promotion;

import com.depotnearby.common.po.promotion.GiftPromotionPolicy;
import com.depotnearby.common.ro.product.ProductRo;
import java.io.Serializable;
import java.util.List;

public class GiftStepPromotionPolicy
extends GiftPromotionPolicy {
    private static final long serialVersionUID = -1068686755119007915L;
    private List<Step> stepList;

    public List<Step> getStepList() {
        return this.stepList;
    }

    public void setStepList(List<Step> stepList) {
        this.stepList = stepList;
    }

    @Override
    public Integer calculateFreeOfQuantity(Integer purchaseQuantity) {
        int max = 0;
        if (this.stepList != null) {
            for (Step step : this.stepList) {
                max = Math.max(max, step.calculateFreeOfQuantity(purchaseQuantity));
            }
        }
        return max;
    }

    @Override
    public String getInfo(String standard, ProductRo productRo) {
        StringBuilder sb = new StringBuilder();
        if (this.stepList != null && this.stepList.size() > 0) {
            for (Step step : this.stepList) {
                sb.append(step.info(standard, productRo)).append(",");
            }
            sb.deleteCharAt(sb.lastIndexOf(","));
        }
        return sb.toString();
    }

    @Override
    public String freeInfo(Integer amount, String standard, ProductRo productRo) {
        int max = 0;
        Step s = null;
        if (this.stepList != null) {
            for (Step step : this.stepList) {
                if (step.calculateFreeOfQuantity(amount) <= max) continue;
                s = step;
            }
        }
        if (s != null) {
            return s.info(standard, productRo);
        }
        return null;
    }

    public static class Step
    implements Serializable {
        private static final long serialVersionUID = 364641898859043293L;
        private Integer purchaseQuantity;
        private Integer freeQuantity;

        public Step() {
        }

        public Step(Integer purchaseQuantity, Integer freeQuantity) {
            this.purchaseQuantity = purchaseQuantity;
            this.freeQuantity = freeQuantity;
        }

        public static long getSerialVersionUID() {
            return 364641898859043293L;
        }

        public Integer getPurchaseQuantity() {
            return this.purchaseQuantity;
        }

        public void setPurchaseQuantity(Integer purchaseQuantity) {
            this.purchaseQuantity = purchaseQuantity;
        }

        public Integer getFreeQuantity() {
            return this.freeQuantity;
        }

        public void setFreeQuantity(Integer freeQuantity) {
            this.freeQuantity = freeQuantity;
        }

        public int calculateFreeOfQuantity(int purchaseQuantity) {
            return purchaseQuantity >= this.purchaseQuantity ? this.freeQuantity : 0;
        }

        public String info(String standard, ProductRo productRo) {
            return "\u8d2d\u4e70\u6ee1" + this.purchaseQuantity + standard + "\u8d60" + this.freeQuantity + productRo.getStandard() + " " + productRo.getName();
        }
    }
}

