/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.po.promotion;

import com.depotnearby.common.po.product.CategoryPo;
import com.depotnearby.common.po.product.ProductPo;
import com.depotnearby.common.po.promotion.ChargePromotionPolicy;
import com.depotnearby.common.po.promotion.GiftPromotionPolicy;
import com.depotnearby.common.po.promotion.SalePromotionPolicyFactory;
import com.depotnearby.common.po.promotion.SalePromotionTargetType;
import com.depotnearby.common.po.promotion.SalePromotionType;
import com.depotnearby.util.DateTool;
import java.sql.Timestamp;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="order_promotion")
public class SalePromotionPo {
    @Id
    private Long id;
    @Column(nullable=false, length=40)
    private String name;
    @Column(length=255)
    private String description;
    @Column(nullable=false)
    @Convert(converter=SalePromotionType.Converter.class)
    private SalePromotionType type;
    private Boolean voucherAble;
    private Boolean mutexAble;
    @Column(nullable=false)
    @Convert(converter=SalePromotionTargetType.Converter.class)
    private SalePromotionTargetType targetType;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="categoryId")
    private CategoryPo category;
    @ManyToMany
    @JoinTable(name="order_promotion_product", joinColumns={@JoinColumn(name="promotionId", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="productId", referencedColumnName="id")})
    private Set<ProductPo> products;
    @Column(length=1023, nullable=false)
    private String promotionPolicyJson;
    private Timestamp startTime;
    private Timestamp endTime;
    private Boolean enable = true;
    private Timestamp lastUpdateTime = DateTool.nowTimestamp();
    @Column(length=40)
    private String handler;
    @Column
    private Integer stockQuantity;

    public boolean isTakeEffect(long timeMillis) {
        return this.enable != null && this.enable != false && this.startTime != null && this.endTime != null && this.startTime.getTime() <= timeMillis && timeMillis <= this.endTime.getTime();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public SalePromotionType getType() {
        return this.type;
    }

    public void setType(SalePromotionType type) {
        this.type = type;
    }

    public Boolean getVoucherAble() {
        return this.voucherAble;
    }

    public void setVoucherAble(Boolean voucherAble) {
        this.voucherAble = voucherAble;
    }

    public Boolean getMutexAble() {
        return this.mutexAble;
    }

    public void setMutexAble(Boolean mutexAble) {
        this.mutexAble = mutexAble;
    }

    public SalePromotionTargetType getTargetType() {
        return this.targetType;
    }

    public void setTargetType(SalePromotionTargetType targetType) {
        this.targetType = targetType;
    }

    public CategoryPo getCategory() {
        return this.category;
    }

    public void setCategory(CategoryPo category) {
        this.category = category;
    }

    public Set<ProductPo> getProducts() {
        return this.products;
    }

    public void setProducts(Set<ProductPo> products) {
        this.products = products;
    }

    public ChargePromotionPolicy getChargePromotionPolicy() {
        return SalePromotionPolicyFactory.stringToChargePromotion(this.promotionPolicyJson);
    }

    public void setPromotionPolicyJson(ChargePromotionPolicy promotionPolicy) {
        this.promotionPolicyJson = SalePromotionPolicyFactory.chargePromotionToString(promotionPolicy);
    }

    public GiftPromotionPolicy getGiftPromotionPolicy() {
        return SalePromotionPolicyFactory.stringToGiftPromotion(this.promotionPolicyJson);
    }

    public void setPromotionPolicyJson(GiftPromotionPolicy promotionPolicy) {
        this.promotionPolicyJson = SalePromotionPolicyFactory.giftPromotionToString(promotionPolicy);
    }

    public String getPromotionPolicyJson() {
        return this.promotionPolicyJson;
    }

    public void setPromotionPolicyJson(String promotionPolicyJson) {
        this.promotionPolicyJson = promotionPolicyJson;
    }

    public Timestamp getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Timestamp startTime) {
        this.startTime = startTime;
    }

    public Timestamp getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Timestamp endTime) {
        this.endTime = endTime;
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public void setEnable(Boolean enable2) {
        this.enable = enable2;
    }

    public Timestamp getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(Timestamp lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public String getHandler() {
        return this.handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    public Integer getStockQuantity() {
        return this.stockQuantity;
    }

    public void setStockQuantity(Integer stockQuantity) {
        this.stockQuantity = stockQuantity;
    }
}

