/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.po.search;

import com.depotnearby.common.po.Persistent;
import com.depotnearby.common.util.PinyinUtil;
import com.depotnearby.search.SuggestIndexDataAdapter;
import java.sql.Timestamp;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name="search_word")
public class SearchWordPo
implements Persistent,
SuggestIndexDataAdapter {
    public static final String LOG_LAST_TS = "last_log_ts";
    @Id
    private int id;
    @Column(length=40)
    private String keyword;
    @Column
    private int times = 1;
    @Column
    private Timestamp ts;

    public SearchWordPo() {
    }

    public SearchWordPo(int id, String word, Timestamp ts) {
        this.id = id;
        this.keyword = word;
        this.ts = ts;
    }

    public SearchWordPo(int id, String word, Timestamp ts, int times) {
        this.id = id;
        this.keyword = word;
        this.ts = ts;
        this.times = times;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public int getTimes() {
        return this.times;
    }

    public void setTimes(int times) {
        this.times = times;
    }

    public Timestamp getTs() {
        return this.ts;
    }

    public void setTs(Timestamp ts) {
        this.ts = ts;
    }

    public SearchWordPo incTimes() {
        ++this.times;
        return this;
    }

    public boolean isAddToIndex() {
        return true;
    }

    public String getContent() {
        StringBuilder sb = new StringBuilder();
        Map<String, String> pinyinMap = PinyinUtil.getPingYinAndChinese(this.keyword);
        if (pinyinMap != null && !pinyinMap.isEmpty()) {
            for (String pinyin : pinyinMap.keySet()) {
                if (pinyin.length() > 50) {
                    pinyin = pinyin.substring(0, 50);
                }
                sb.append(pinyin).append(" ");
            }
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        String str = "\u5bab\u6811\u6d9b\u7684";
        StringBuilder sb = new StringBuilder();
        Map<String, String> pinyinMap = PinyinUtil.getPingYinAndChinese(str);
        if (pinyinMap != null && !pinyinMap.isEmpty()) {
            for (String pinyin : pinyinMap.keySet()) {
                if (pinyin.length() > 50) {
                    pinyin = pinyin.substring(0, 50);
                }
                sb.append(pinyin).append(" ");
            }
        }
        System.out.println(sb.toString());
    }
}

