/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.po.voucher;

import com.depotnearby.common.model.IOrder;
import com.depotnearby.common.po.Persistent;
import com.depotnearby.common.po.product.CategoryPo;
import com.depotnearby.common.po.product.ProductPo;
import com.depotnearby.common.po.product.SaleAreaPo;
import com.depotnearby.common.po.user.ShopTypePo;
import com.depotnearby.common.po.voucher.VoucherExpireType;
import com.depotnearby.common.po.voucher.VoucherLimitType;
import com.depotnearby.common.po.voucher.VoucherTypeStatus;
import com.depotnearby.common.ro.voucher.VoucherTypeRo;
import java.sql.Timestamp;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.collections.CollectionUtils;
import org.codelogger.utils.StringUtils;

@Entity
@Table(name="vou_type")
public class VoucherTypePo
implements Persistent {
    @Id
    @Column(length=50)
    private Long id;
    @Column(length=50, nullable=false)
    private String name;
    @Column(nullable=false)
    private int faceValue;
    @Column(nullable=true)
    private Integer paymentLimit;
    @Column(columnDefinition="TINYINT", nullable=false)
    @Convert(converter=VoucherExpireType.VoucherExpireTypeConverter.class)
    private VoucherExpireType voucherExpireType;
    @Column(nullable=false)
    private int periodDays;
    @Column(nullable=false)
    private int minCountInPool;
    @Column(length=50)
    private String mailTo;
    @Column(length=50, nullable=true)
    private String issuerName;
    @Column(length=255)
    private String description;
    @Column
    private Integer issueCount = 0;
    @Column
    private Timestamp createTime;
    @Column
    private Timestamp startTime;
    @Column
    private Timestamp expireTime;
    @Column(columnDefinition="TINYINT", nullable=false)
    @Convert(converter=VoucherTypeStatus.VoucherTypeStatusConverter.class)
    private VoucherTypeStatus typeStatus;
    @Column(nullable=false)
    private int mutexPriority;
    @Column(nullable=false)
    private int fetchType;
    @Column(nullable=false)
    private int useStatus;
    @Column(nullable=false)
    private String paymentType;
    private Timestamp deletedAt;
    @Column(columnDefinition="TINYINT", nullable=false)
    @Convert(converter=VoucherLimitType.VoucherLimitTypeConverter.class)
    private VoucherLimitType voucherLimitType;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="categoryId")
    private CategoryPo category;
    @ManyToMany
    @JoinTable(name="vou_type_product", joinColumns={@JoinColumn(name="typeId", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="productId", referencedColumnName="id")})
    private Set<ProductPo> products;
    @ManyToMany
    @JoinTable(name="vou_type_salearea", joinColumns={@JoinColumn(name="typeId", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="saleAreaId", referencedColumnName="id")})
    private Set<SaleAreaPo> saleAreas;
    @ManyToMany
    @JoinTable(name="vou_type_shoptype", joinColumns={@JoinColumn(name="typeId", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="shopTypeId", referencedColumnName="id")})
    private Set<ShopTypePo> shopTypes;

    public VoucherTypePo() {
    }

    public VoucherTypePo(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getFaceValue() {
        return this.faceValue;
    }

    public void setFaceValue(int faceValue) {
        this.faceValue = faceValue;
    }

    public VoucherExpireType getVoucherExpireType() {
        return this.voucherExpireType;
    }

    public void setVoucherExpireType(VoucherExpireType voucherExpireType) {
        this.voucherExpireType = voucherExpireType;
    }

    public Integer getPaymentLimit() {
        return this.paymentLimit;
    }

    public void setPaymentLimit(Integer paymentLimit) {
        this.paymentLimit = paymentLimit;
    }

    public int getPeriodDays() {
        return this.periodDays;
    }

    public void setPeriodDays(int periodDays) {
        this.periodDays = periodDays;
    }

    public int getMinCountInPool() {
        return this.minCountInPool;
    }

    public void setMinCountInPool(int minCountInPool) {
        this.minCountInPool = minCountInPool;
    }

    public String getMailTo() {
        return this.mailTo;
    }

    public void setMailTo(String mailTo) {
        this.mailTo = mailTo;
    }

    public String getIssuerName() {
        return this.issuerName;
    }

    public void setIssuerName(String issuerName) {
        this.issuerName = issuerName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getIssueCount() {
        return this.issueCount;
    }

    public void setIssueCount(Integer issueCount) {
        this.issueCount = issueCount;
    }

    public Timestamp getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Timestamp createTime) {
        this.createTime = createTime;
    }

    public Timestamp getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Timestamp startTime) {
        this.startTime = startTime;
    }

    public Timestamp getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(Timestamp expireTime) {
        this.expireTime = expireTime;
    }

    public VoucherTypeStatus getTypeStatus() {
        return this.typeStatus;
    }

    public void setTypeStatus(VoucherTypeStatus typeStatus) {
        this.typeStatus = typeStatus;
    }

    public int getMutexPriority() {
        return this.mutexPriority;
    }

    public void setMutexPriority(int mutexPriority) {
        this.mutexPriority = mutexPriority;
    }

    public int getFetchType() {
        return this.fetchType;
    }

    public void setFetchType(int fetchType) {
        this.fetchType = fetchType;
    }

    public int getUseStatus() {
        return this.useStatus;
    }

    public void setUseStatus(int useStatus) {
        this.useStatus = useStatus;
    }

    public String getPaymentType() {
        return this.paymentType;
    }

    public void setPaymentType(String paymentType) {
        this.paymentType = StringUtils.isBlank((String)paymentType) ? IOrder.PaymentType.ALIPAY + "," + IOrder.PaymentType.WECHAT : paymentType;
    }

    public Timestamp getDeletedAt() {
        return this.deletedAt;
    }

    public void setDeletedAt(Timestamp deletedAt) {
        this.deletedAt = deletedAt;
    }

    public Set<ShopTypePo> getShopTypes() {
        return this.shopTypes;
    }

    public void setShopTypes(Set<ShopTypePo> shopTypes) {
        this.shopTypes = shopTypes;
    }

    public VoucherLimitType getVoucherLimitType() {
        return this.voucherLimitType;
    }

    public void setVoucherLimitType(VoucherLimitType voucherLimitType) {
        this.voucherLimitType = voucherLimitType;
    }

    public CategoryPo getCategory() {
        return this.category;
    }

    public void setCategory(CategoryPo category) {
        this.category = category;
    }

    public Set<ProductPo> getProducts() {
        return this.products;
    }

    public void setProducts(Set<ProductPo> products) {
        this.products = products;
    }

    public Set<SaleAreaPo> getSaleAreas() {
        return this.saleAreas;
    }

    public void setSaleAreas(Set<SaleAreaPo> saleAreas) {
        this.saleAreas = saleAreas;
    }

    public VoucherTypeRo voucherTypePo2Ro() {
        StringBuffer sb;
        VoucherTypeRo voucherTypeRo = new VoucherTypeRo();
        voucherTypeRo.setId(this.getId());
        voucherTypeRo.setName(this.getName());
        voucherTypeRo.setPaymentLimit(this.getPaymentLimit());
        voucherTypeRo.setTypeStatus(this.getTypeStatus());
        voucherTypeRo.setFetchType(this.getFetchType());
        voucherTypeRo.setUseStatus(this.getUseStatus());
        voucherTypeRo.setFaceValue(this.getFaceValue());
        voucherTypeRo.setPeriodDays(this.getPeriodDays());
        voucherTypeRo.setDescription(this.getDescription());
        voucherTypeRo.setStartTime(this.getStartTime().getTime());
        voucherTypeRo.setExpireTime(this.getExpireTime().getTime());
        voucherTypeRo.setVoucherExpireType(this.voucherExpireType);
        voucherTypeRo.setVoucherLimitType(this.voucherLimitType);
        voucherTypeRo.setIssueCount(this.getIssueCount());
        voucherTypeRo.setPaymentType(this.getPaymentType());
        if (CollectionUtils.isNotEmpty(this.shopTypes)) {
            sb = new StringBuffer();
            sb.append(",");
            for (ShopTypePo shopType : this.shopTypes) {
                sb.append(shopType.getId()).append(",");
            }
            voucherTypeRo.setShopTypeIds(sb.toString());
        } else {
            voucherTypeRo.setShopTypeIds("");
        }
        if (CollectionUtils.isNotEmpty(this.saleAreas)) {
            sb = new StringBuffer();
            sb.append(",");
            for (SaleAreaPo saleArea : this.saleAreas) {
                sb.append(saleArea.getId()).append(",");
            }
            voucherTypeRo.setSaleAreaIds(sb.toString());
        } else {
            voucherTypeRo.setSaleAreaIds("");
        }
        if (this.getCategory() != null) {
            voucherTypeRo.setLimitInfo("\u4ec5" + this.getCategory().getName() + "\u53ef\u7528");
            voucherTypeRo.setCategoryId(this.getCategory().getId());
        } else if (CollectionUtils.isNotEmpty(this.products)) {
            sb = new StringBuffer();
            sb.append(",");
            for (ProductPo p : this.products) {
                sb.append(p.getId()).append(",");
            }
            voucherTypeRo.setProductIds(sb.toString());
            voucherTypeRo.setLimitInfo("\u4ec5\u9650\u90e8\u5206\u5546\u54c1\u53ef\u7528");
        } else {
            voucherTypeRo.setLimitInfo("\u5168\u573a\u53ef\u7528");
            voucherTypeRo.setCategoryId(null);
            voucherTypeRo.setProductIds("");
        }
        return voucherTypeRo;
    }
}

