/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.po.ximu;

import com.depotnearby.common.po.Persistent;
import com.depotnearby.common.po.order.OrderPo;
import com.depotnearby.common.po.ximu.XiMuLoanStatusConverter;
import com.depotnearby.util.DateTool;
import com.depotnearby.vo.ximu.constants.InteCompKind;
import com.depotnearby.vo.ximu.constants.LoanType;
import com.depotnearby.vo.ximu.constants.XiMuLoanPeriod;
import com.depotnearby.vo.ximu.constants.XiMuLoanStatus;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.lang.builder.ToStringBuilder;

@Entity
@Table(name="ximu_loan")
public class XiMuLoanPo
implements Persistent {
    static final Integer XIMU_LOAN_DELIVERY = 3;
    @Id
    private Long id;
    @ManyToOne(optional=false)
    @JoinColumn(name="orderId")
    private OrderPo order;
    @Column(nullable=false)
    private Long shopId;
    @Column(nullable=false)
    private Timestamp applyTime;
    @Column(nullable=false, length=8)
    private Integer loanPeriod = XiMuLoanPeriod.THIRTY.getValue();
    @Column(nullable=false)
    private LoanType loanType = LoanType.DAY;
    @Column(nullable=false)
    private String chargeRate = "";
    @Column(nullable=false)
    private long applyBal;
    @Column(nullable=false, length=20)
    private InteCompKind inteCompKind = InteCompKind.DAY_SELF_RETURNING;
    @Column(nullable=false, length=100)
    private String clientIp;
    @Column(nullable=false)
    private Timestamp actionDate;
    @Column(columnDefinition="TINYINT", nullable=false)
    @Convert(converter=XiMuLoanStatusConverter.class)
    private XiMuLoanStatus status;
    @Column(nullable=true, length=255)
    private String faildInfo;
    @Column(nullable=false)
    private Timestamp createTime;
    @Column(nullable=true, length=50)
    private String xmListCode;
    private Long xiMuPayPrice;
    @Column(nullable=true, length=50)
    private String agreeCode;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public OrderPo getOrder() {
        return this.order;
    }

    public void setOrder(OrderPo orderPo) {
        this.order = orderPo;
    }

    public Long getShopId() {
        return this.shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Timestamp getApplyTime() {
        return this.applyTime;
    }

    public void setApplyTime(Timestamp applyTime) {
        this.applyTime = applyTime;
    }

    public Integer getLoanPeriod() {
        return this.loanPeriod;
    }

    public void setLoanPeriod(Integer loanPeriod) {
        this.loanPeriod = loanPeriod;
    }

    public LoanType getLoanType() {
        return this.loanType;
    }

    public void setLoanType(LoanType loanType) {
        this.loanType = loanType;
    }

    public String getChargeRate() {
        return this.chargeRate;
    }

    public void setChargeRate(String chargeRate) {
        int len = chargeRate.substring(chargeRate.lastIndexOf(".") + 1).length();
        while (len++ < 4) {
            chargeRate = chargeRate + "0";
        }
        this.chargeRate = chargeRate;
    }

    public long getApplyBal() {
        return this.applyBal;
    }

    public void setApplyBal(long applyBal) {
        this.applyBal = applyBal;
    }

    public InteCompKind getInteCompKind() {
        return this.inteCompKind;
    }

    public void setInteCompKind(InteCompKind inteCompKind) {
        this.inteCompKind = inteCompKind;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public Timestamp getActionDate() {
        return this.actionDate;
    }

    public void setActionDate(Timestamp actionDate) {
        this.actionDate = actionDate;
    }

    public XiMuLoanStatus getStatus() {
        return this.status;
    }

    public void setStatus(XiMuLoanStatus status) {
        this.status = status;
    }

    public String getFaildInfo() {
        return this.faildInfo;
    }

    public void setFaildInfo(String faildInfo) {
        this.faildInfo = faildInfo;
    }

    public Timestamp getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Timestamp createTime) {
        this.createTime = createTime;
    }

    public String getXmListCode() {
        return this.xmListCode;
    }

    public void setXmListCode(String xmListCode) {
        this.xmListCode = xmListCode;
    }

    public String getAgreeCode() {
        return this.agreeCode;
    }

    public void setAgreeCode(String agreeCode) {
        this.agreeCode = agreeCode;
    }

    public Timestamp getLoanDate() {
        return DateTool.afterDays((Date)this.getDeliveryDate(), (Integer)this.getLoanPeriod());
    }

    public Timestamp getDeliveryDate() {
        return DateTool.afterDays((Date)this.getApplyTime(), (Integer)XIMU_LOAN_DELIVERY);
    }

    public String getFormatChargeRate() {
        return String.format("%.2f", new BigDecimal(this.chargeRate).multiply(new BigDecimal("100"))) + "%";
    }

    public Long getXiMuPayPrice() {
        return this.xiMuPayPrice;
    }

    public void setXiMuPayPrice(Long xiMuPayPrice) {
        this.xiMuPayPrice = xiMuPayPrice;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

