/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.ro;

import com.depotnearby.common.IdType;
import com.depotnearby.common.SMSType;
import com.depotnearby.common.model.IStatus;
import com.depotnearby.common.shop.ShopChannel;
import com.depotnearby.common.shop.ShopTypeStatus;

public class RedisKeyGenerator {

    public static class RedPriceRedisKey {
        public static String getRedPriceAreaProcduceKey(String areaCode, String productCode) {
            return "redprice:" + areaCode + "_" + productCode;
        }
    }

    public static class AreaPrice {
        public static String getAreaPriceKey(Long productId, Integer areaId) {
            return "price:" + productId + "_" + areaId;
        }
    }

    public static class Message {
        public static String getQueueOfProcessingKey() {
            return "mqMsg:processing";
        }
    }

    public static class Nuomi {
        public static String getDepotProductLimitKey(Long productId, String depotId) {
            return "global:nuomi:" + depotId + ":" + productId;
        }

        public static String getProductLimitPeriodKey(Long productId) {
            return "global:nuomi:limit_product_period:" + productId;
        }

        public static String getProductLimitKey(Long productId) {
            return "global:nuomi:limit_product:" + productId;
        }

        public static String getUserProductLimitPeriodKey(Long userId, Long productId) {
            return "global:nuomi:user_limit_period:" + userId + "_" + productId;
        }

        public static String getUserProductPeriodField(String date) {
            return "date:" + date;
        }

        public static String getLimitCityCodeKey() {
            return "global:nuomi:limit_citycode";
        }

        public static String getIsLimitKey() {
            return "global:nuomi:is_limit";
        }
    }

    public static class Stock {
        public static String getDepotProductStockHashKey(String mcuCode, String centerId) {
            return "stock:stock_all:" + mcuCode + "_" + centerId;
        }

        public static String getDepotProductStockChangeHashKey(Long id) {
            if (id == null) {
                return null;
            }
            return "stock:stock_change:" + id;
        }

        public static String getDepotProductBlockStockKey(String mcuCode, String centerId) {
            return "stock:stock_block:" + mcuCode + "_" + centerId;
        }

        public static String getDepotProductDoneStockChangeIdStringKey(Long changeId) {
            return "stock:stock_done_change_id:" + changeId;
        }

        public static String getDepotProductToBeRemovedSetKey(String type) {
            return "stock:stock_removed_keys_" + type;
        }
    }

    public static class Ximu {
        public static String getAllowBalStringKey(Long shopId) {
            return "global:sximu_allowbal:" + shopId;
        }

        public static String getShopApplyPhoto(Long shopId, Integer pageIndex) {
            return "account:apply:image:" + shopId + ":" + pageIndex;
        }

        public static String getXimuAgreeDateCodeKey(String yearAndMonth) {
            return "ximu:code_ximu_loan_agree_date_" + yearAndMonth;
        }

        public static String getXimuFileLatestSyncTimestampKey(String type) {
            return "ximu:latest_sync_time:" + type;
        }
    }

    public static class Security {
        public static String getStringValueWithTimestampScoreSortSetKey(String key) {
            return "global:security:" + key;
        }
    }

    public static class SMS {
        public static String getSmsCodeHashKey(String mobile, SMSType smsType) {
            return "sms:" + mobile + ":" + smsType.name();
        }
    }

    public static class Program {
        public static String getProgramHashKey(String id) {
            return "program:".concat(id);
        }

        public static String getJoinProgramSortSetKeyByCoverId(String coverId) {
            return "cover:joinprogram:".concat(coverId);
        }
    }

    public static class Cover {
        public static String getAllCoverSortSetKey() {
            return "global:coverId";
        }

        public static String getCoverHashKey(String id) {
            return "cover:".concat(id);
        }

        public static String getCoverCitySortSetKey(Integer cityId) {
            return "global:cover:city:" + cityId;
        }

        public static String getCoverClientSortSetKey(Byte clientTypeValue) {
            return "global:cover:clientType:" + clientTypeValue;
        }
    }

    public static class Voucher {
        public static String getVoucherHashKey(Long voucherId) {
            return "voucher:voucher_" + voucherId;
        }

        public static String getUserVoucherUnusedSortSetKey(Long userId) {
            return "user:voucher_unused:" + userId;
        }

        public static String getUserVoucherUsedSortSetKey(Long userId) {
            return "user:voucher_used:" + userId;
        }

        public static String getUserVoucherExpiredSortSetKey(Long userId) {
            return "user:voucher_expired:" + userId;
        }

        public static String getUserAllVouchersSortSetKey(Long userId) {
            return "user:voucher_all:" + userId;
        }
    }

    public static class VoucherType {
        public static String getVoucherTypeSortSetKey() {
            return "global:voucher_type_set";
        }

        public static String getVoucherTypeHashKey(Long id) {
            return "global:voucher_type_" + id;
        }

        public static String getVoucherTypeVoucherListKey(Long id) {
            return "global:voucher_type_voucher_list_" + id;
        }

        public static String getVoucherConfigureHashKey(String key) {
            return "global:voucher_configure:" + key;
        }
    }

    public static class ShoppingCart {
        public static String getShoppingCartUserIdSortedSetKey(Long userId) {
            return "shopping_cart:userId:" + userId;
        }

        public static String getWisdomProductSetKey(Long userId) {
            return "wisdomProduct:userId:" + userId;
        }
    }

    public static class Order {
        public static String getAllOrderIdsSortSetKey(Long userId) {
            return "order:all:" + userId;
        }

        public static String getWaitForPayOrderIdsSortSetKey(Long userId) {
            return "order:wait_for_pay:" + userId;
        }

        public static String getWaitForReceiveOrderIdsSortSetKey(Long userId) {
            return "order:wait_for_receive:" + userId;
        }

        public static String getFinishedOrderIdsSortSetKey(Long userId) {
            return "order:finished:" + userId;
        }

        public static String getCancelOrderIdSortSetKey(Integer userId) {
            return "order:cancel:" + userId;
        }

        public static String getWaitForAcceptSortSetKey() {
            return "global:wait_for_accept";
        }

        public static String getPayLimitSortSetKey() {
            return "global:pay_limit";
        }

        public static String getSyncOMSFailedSetKey() {
            return "order:sync_oms_failed";
        }

        public static String getCancelOMSFailedSetKey() {
            return "order:cancel_oms_failed";
        }

        public static String getNuomiOrderSortSetKey(long prefix) {
            return "order:nuomi:" + prefix;
        }

        public static String getOrderCodeKey(String yearAndMonth) {
            return "order:code_" + yearAndMonth;
        }

        public static String getSyncNuomiFailedSetKey() {
            return "order:sync_nuomi_failed";
        }

        public static String getOrderId2OrderCodeSortSetKey(String dateStr) {
            return "order:orderId_code:" + dateStr;
        }

        public static String getOrderDepotProductStockFieldKey(String mcuCode, String centerId) {
            return "order:mcuCode_centerId:" + mcuCode + "_" + centerId;
        }
    }

    public static class Search {
        public static String getSearchLogQueueKey() {
            return "global:searchlog";
        }

        public static String getConfigHashKey() {
            return "global:searchconfig";
        }

        public static String getLockByTypeNameKey(String indexTypeName) {
            return "global:search_build_lock:" + indexTypeName;
        }
    }

    public static class Increase {
        public static String getProductSortSetKey() {
            return "global:inc:product";
        }

        public static String getDepotProductSortSetKey() {
            return "global:inc:depot_product";
        }

        public static String getProductLockSellSortSetKey() {
            return "global:inc:product_lock_sell";
        }
    }

    public static class Depot {
        public static String getMcuCodeToDepotIdKey(String mcuCode) {
            return "depot:mcu_code:" + mcuCode;
        }

        public static String getAreaNoToDepotIdsSetKey(String areaNo) {
            return "depot:area:" + areaNo;
        }

        public static String getPartnerDepotSortedSetKey() {
            return "depot:partner_depot";
        }
    }

    public static class ProductToSalePromotionList {
        public static String getProductToSalePromotionListSetKey(Long productId) {
            return "global:productToSalePromotionList:" + productId;
        }
    }

    public static class SalePromotion {
        public static String getSalePromotionAndProductToStockQuantityListKey(Long salePromotionId, Long productId) {
            return "global:salePromotion:stockQuantity:" + salePromotionId + ":" + productId;
        }

        public static String getSalePromotionTargetTypeAllSetKey() {
            return "global:salePromotion:targetType:all";
        }

        public static String getSalePromotionTargetTypeCategorySetKey() {
            return "global:salePromotion:targetType:category";
        }

        public static String getProductSalePromotionSetKey(Long productId) {
            return "global:product:salePromotion" + productId;
        }
    }

    public static class ProductCompany {
        public static String getProductCompanyHashKey(Long productId, Long companyId) {
            return "product:company:" + productId + "_" + companyId;
        }

        public static String getCompanyProductLockSellSetKey(Long productId) {
            return "company:product:lockSell" + productId;
        }

        public static String getProductLockSellCompanySetKey() {
            return "product:lockSell:company";
        }

        public static String getProductLockSellRoCompanySetKey(Long productId) {
            return "product:lockSellRo:company" + productId;
        }
    }

    public static class DepotProduct {
        public static String getDepotProductHashKey(Long productId, String depotId) {
            return "product:depot:" + productId + "_" + depotId;
        }
    }

    public static class PriceTag {
        public static String getPriceTagHashKey(Integer id) {
            return "global:priceTag:" + id;
        }
    }

    public static class ContentNode {
        public static String getContentNodeHashKey(Long id) {
            return "content:node:" + id;
        }
    }

    public static class ContentBody {
        public static String getHashKey(Integer id) {
            return "content:body:" + id;
        }
    }

    public static class Product {
        public static String getStockFieldName() {
            return "showQuantity";
        }

        public static String getVitualStockFieldName() {
            return "virtualQuantity";
        }

        public static String getProductHashKey(Long id) {
            return "product:product:" + id;
        }

        public static String getBehaviourLogQueueKey() {
            return "global:behaviourlog";
        }

        public static String getDefaultRecommendProductSortSetKey() {
            return "global:recommed_product";
        }

        public static String getCenterIdToProductIdKey(String centerId) {
            return "product:centerId:" + centerId;
        }

        public static String getAreaSaleHashKey(Integer areaId) {
            return "product:areasale:" + areaId;
        }

        public static String getAreaSaleOfStatusNormalSetKey() {
            return "product:areasale:status_" + IStatus.STATUS_NORMAL;
        }
    }

    public static class Log {
        public static String getLogQueueKey() {
            return "global:log";
        }
    }

    public static class Upgrade {
        public static String getUpgradeSortSetKey(String os) {
            return "global:all_upgrade:" + os;
        }

        public static String getUpgradeHashKey(String id) {
            return "global:upgrade:" + id;
        }
    }

    public static class Adv {
        public static String getAdvHashKey(Long id) {
            return "info:adv:" + id;
        }

        public static String getAllAdvSortSetKey() {
            return "global:all_adv";
        }
    }

    public static class Promotion {
        public static String getPromotionHashKey(Long id) {
            return "info:promotion:" + id;
        }

        public static String getAllPromotionSortSetKey() {
            return "global:all_promotionIds";
        }

        public static String getSystemLatestUpdateTimeHashKey() {
            return "global:promotion_system_latestUpdateTime";
        }

        public static String getUserLatestUpdateTimeHashKey(Long userId) {
            return "global:promotion_user_latestUpdateTime:" + userId;
        }
    }

    public static class Notice {
        public static String getNoticeHashKey(Long id) {
            return "info:notice:" + id;
        }

        public static String getUserNoticeSortSetKey(Long userId) {
            return "user:notice:" + userId;
        }
    }

    public static class Shop {
        public static String getShopHashKey(Long shopId) {
            return "shop:" + shopId;
        }

        public static String getLogisticsCompanyHashKey(Long logisticsId) {
            return "shop:logistics" + logisticsId;
        }

        public static String getAllShopSortSetKey() {
            return "global:all_shopIds";
        }

        public static String getAllLogisticsCompanySortSetKey() {
            return "global:all_logistics";
        }

        public static String getShopTypeHashKey(Long shopTypeId) {
            return "shop:type:" + shopTypeId;
        }

        public static String getAllShopTypeSortSetKey() {
            return "global:all_shopTypeIds";
        }

        public static String getAllShopTypeOfStatusSortSetKey(ShopTypeStatus shopTypeStatus) {
            return "global:all_shopTypeIds:status_" + shopTypeStatus.getValue();
        }

        public static String getAllLogisticsOfStatusSortSetKey(ShopTypeStatus shopTypeStatus) {
            return "global:all_logisticsIds:status_" + shopTypeStatus.getValue();
        }

        public static String getChannelAndChannelUserIdToShopIdHashKey(Integer channel, String channelUserId) {
            return "global:channel:" + channel + ":shop:" + channelUserId;
        }

        public static String getBlackListShopKey() {
            return "global:black_list_shop";
        }
    }

    public static class User {
        public static final String DEVICEID = "lastLoginDeviceToken";
        public static final String TOEKN = "lastToken";
        public static final String LASTUSERAGENT = "lastUserAgent";

        public static String getUserInfoHashKey(Long userId) {
            return "user:user_" + userId;
        }

        @Deprecated
        public static String[] getMobileKeyAndField(String mobile) {
            return new String[]{"global:mobile:" + mobile.substring(0, 9), mobile.substring(9)};
        }

        public static String getMobileToUserIdHashKey(String mobile) {
            return "global:mobile:" + mobile;
        }

        public static String getChannelUserIdToUserIdHashKey(ShopChannel shopChannel, String channelUserId) {
            return "global:channel:" + shopChannel.getValue() + ":user:" + channelUserId;
        }

        public static String getChannelMobileToChannelUserIdHashKey(ShopChannel shopChannel, String mobile) {
            return "global:channel:" + shopChannel.getValue() + ":mobile:" + mobile;
        }

        public static String getAllUserSortSetKey() {
            return "global:all_userIds";
        }

        public static String getRecommendUserHashKey(String tel) {
            return "user:recommend:" + tel;
        }

        public static String getRegisterFailedUserHashKey() {
            return "user:register_failed_ids";
        }

        public static String getResetPwdToOMSFailedUserHashKey() {
            return "user:reset_pwd_to_oms_failed_ids";
        }

        public static String getBlockCreateOrderUserKey() {
            return "global:block_create_order_user";
        }

        public static String getShareTimesKey() {
            return "global:shareTimes";
        }
    }

    public static class Navigation {
        public static String getNavigationHashKey(Long id) {
            return "global:navigation:" + id;
        }

        public static String getAllNavigationSortSetKey() {
            return "global:all_navigation";
        }
    }

    public static class Banner {
        public static String getBannerHashKey(Long id) {
            return "global:banner:" + id;
        }

        public static String getBannerInCategorySortSetKey(Integer categoryId) {
            return "global:banner_in_category:" + categoryId;
        }
    }

    public static class Device {
        public static String getUserDeviceListKey() {
            return "global:device_list";
        }
    }

    public static class Category {
        public static final String FilterJsonFileName = "filterJson";

        public static String getHashKey(Integer id) {
            return "global:category" + id;
        }
    }

    public static class PriceConfig {
        public static String getPriceConfigHashKey() {
            return "global:price_config";
        }
    }

    public static class StockConfig {
        public static String getStockConfigHashKey() {
            return "global:stock_config";
        }
    }

    public static class OrderConfig {
        public static String getOrderConfigHashKey() {
            return "global:order_config";
        }
    }

    public static class AppConfig {
        public static String getAppConfigHashKey() {
            return "global:app_config";
        }

        public static String getSidesliBarConfigHashKey() {
            return "global:sidesliBar_config";
        }
    }

    public static class System {
        public static String getConfigHashKey() {
            return "global:config";
        }

        public static String getIdPoolListKey(IdType idType) {
            return idType.name() + "_idPool";
        }
    }
}

