/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.ro.config;

import com.depotnearby.common.util.ExternalizationHelper;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.commons.lang3.StringUtils;

public class AppSideslipBarConfigRo
implements Externalizable,
Comparable<AppSideslipBarConfigRo> {
    private String id;
    private String name;
    private String color;
    private String icon;
    @JsonIgnore
    private Integer sortNumber;

    public AppSideslipBarConfigRo() {
    }

    public AppSideslipBarConfigRo(BarType barType, String icon) {
        this.id = barType.name();
        this.name = barType.getName();
        this.color = barType.getColor();
        this.sortNumber = barType.getSortNumber();
        this.icon = icon;
    }

    @Override
    public int compareTo(AppSideslipBarConfigRo o) {
        if (this.getSortNumber() == null || o.getSortNumber() == null) {
            return 0;
        }
        if (this.getSortNumber() > o.getSortNumber()) {
            return -1;
        }
        if (this.getSortNumber() < o.getSortNumber()) {
            return 1;
        }
        if (StringUtils.isBlank((CharSequence)this.getName()) || StringUtils.isBlank((CharSequence)o.getName())) {
            return -1;
        }
        if (this.getSortNumber() == o.getSortNumber()) {
            return this.getName().compareTo(o.getName());
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppSideslipBarConfigRo that = (AppSideslipBarConfigRo)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.color != null ? !this.color.equals(that.color) : that.color != null) {
            return false;
        }
        if (this.icon != null ? !this.icon.equals(that.icon) : that.icon != null) {
            return false;
        }
        return !(this.sortNumber == null ? that.sortNumber != null : !this.sortNumber.equals(that.sortNumber));
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.color != null ? this.color.hashCode() : 0);
        result = 31 * result + (this.icon != null ? this.icon.hashCode() : 0);
        result = 31 * result + (this.sortNumber != null ? this.sortNumber.hashCode() : 0);
        return result;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getSortNumber() {
        return this.sortNumber;
    }

    public void setSortNumber(Integer sortNumber) {
        this.sortNumber = sortNumber;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ExternalizationHelper.writeString(out, this.name);
        ExternalizationHelper.writeString(out, this.color);
        ExternalizationHelper.writeString(out, this.icon);
        ExternalizationHelper.writeString(out, this.id);
        ExternalizationHelper.writeInteger(out, this.sortNumber);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = ExternalizationHelper.readString(in);
        this.color = ExternalizationHelper.readString(in);
        this.icon = ExternalizationHelper.readString(in);
        this.id = ExternalizationHelper.readString(in);
        this.sortNumber = ExternalizationHelper.readInteger(in);
    }

    public String toString() {
        return "AppSideslipBarConfigRo{id=" + this.id + ", name='" + this.name + '\'' + ", color='" + this.color + '\'' + ", icon='" + this.icon + '\'' + '}';
    }

    public static enum BarType {
        ORDER("\u6211\u7684\u8ba2\u5355", "0099FF", 1),
        CURTAIN("\u8bb0\u6211\u8d26\u4e0a", "FF0000", 2),
        RED_PACKAGE("\u7ea2\u5305", "FF0000", 3),
        RECOMMEND("\u63a8\u8350\u6709\u793c", "FF0000", 4),
        ACTIVITY("\u6d3b\u52a8\u4e2d\u5fc3", "0099FF", 5),
        MESSAGE("\u6d88\u606f\u4e2d\u5fc3", "0099FF", 6),
        CUSTOMER_SERVICE("\u8054\u7cfb\u5ba2\u670d", "0099FF", 7),
        SETTING("\u8bbe\u7f6e", "0099FF", 8);

        private String name;
        private String color;
        private Integer sortNumber;

        public String getName() {
            return this.name;
        }

        public String getColor() {
            return this.color;
        }

        public Integer getSortNumber() {
            return this.sortNumber;
        }

        private BarType(String value, String color, Integer sortNumber) {
            this.name = value;
            this.color = color;
            this.sortNumber = sortNumber;
        }
    }
}

