/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.ro.voucher;

import com.depotnearby.common.ro.AbstractRedisObj;
import com.depotnearby.common.ro.voucher.VoucherTypeWithQuantity;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VoucherConfigureRo
extends AbstractRedisObj {
    private static final Logger logger = LoggerFactory.getLogger(VoucherConfigureRo.class);
    public static final String SPLIT_PLACEHOLDER = ",";
    public static final String SPLIT_TYPE_QUANTITY = ":";
    private String voucherconfigure;
    private String voucherTypes;

    public String getVoucherconfigure() {
        return this.voucherconfigure;
    }

    public void setVoucherconfigure(String voucherconfigure) {
        this.voucherconfigure = voucherconfigure;
    }

    public String getVoucherTypes() {
        return this.voucherTypes;
    }

    public void setVoucherTypes(String v) {
        this.voucherTypes = v;
    }

    @Deprecated
    public List<Long> getVoucherTypeIds() {
        ArrayList voucherTypeIds = Lists.newArrayList();
        if (this.voucherTypes != null) {
            String[] stringOfVoucherTypeIds;
            for (String stringOfVoucherTypeId : stringOfVoucherTypeIds = this.voucherTypes.split(SPLIT_PLACEHOLDER)) {
                voucherTypeIds.add(Long.valueOf(stringOfVoucherTypeId));
            }
        }
        return voucherTypeIds;
    }

    public Map<Long, VoucherTypeWithQuantity> getVoucherTypeWithQuantity() {
        String[] stringOfVoucherTypeIds;
        LinkedHashMap<Long, VoucherTypeWithQuantity> result = new LinkedHashMap<Long, VoucherTypeWithQuantity>();
        if (this.voucherTypes != null && (stringOfVoucherTypeIds = this.voucherTypes.split(SPLIT_PLACEHOLDER)) != null && stringOfVoucherTypeIds.length > 0) {
            for (String stringOfVoucherTypeId : stringOfVoucherTypeIds) {
                if (!StringUtils.isNotBlank((CharSequence)stringOfVoucherTypeId)) continue;
                String[] idWithQuantityArray = stringOfVoucherTypeId.split(SPLIT_TYPE_QUANTITY);
                try {
                    if (idWithQuantityArray == null) continue;
                    long voucherTypeId = Long.valueOf(idWithQuantityArray[0]);
                    if (idWithQuantityArray.length == 2) {
                        result.put(voucherTypeId, new VoucherTypeWithQuantity(voucherTypeId, Integer.parseInt(idWithQuantityArray[1])));
                        continue;
                    }
                    if (idWithQuantityArray.length != 1) continue;
                    result.put(voucherTypeId, new VoucherTypeWithQuantity(voucherTypeId));
                }
                catch (Exception e) {
                    logger.error("getVoucherTypeWithQuantity", (Throwable)e);
                }
            }
        }
        return result;
    }

    private void join(Map<Long, VoucherTypeWithQuantity> map) {
        if (map != null && !map.isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean isFirstVisited = true;
            for (VoucherTypeWithQuantity object : map.values()) {
                if (isFirstVisited) {
                    isFirstVisited = false;
                } else {
                    stringBuffer.append(SPLIT_PLACEHOLDER);
                }
                stringBuffer.append(object.toJoinStr(SPLIT_TYPE_QUANTITY));
            }
            this.voucherTypes = stringBuffer.toString();
        } else {
            this.voucherTypes = "";
        }
    }

    public void addVoucherTypes(Long voucherTypeId, int quantity) {
        if (voucherTypeId != null && quantity > 0) {
            Map<Long, VoucherTypeWithQuantity> map = this.getVoucherTypeWithQuantity();
            map.put(voucherTypeId, new VoucherTypeWithQuantity(voucherTypeId, quantity));
            this.join(map);
        }
    }

    public void removeVoucherType(Long voucherTypeId) {
        if (voucherTypeId != null) {
            Map<Long, VoucherTypeWithQuantity> map = this.getVoucherTypeWithQuantity();
            map.remove(voucherTypeId);
            this.join(map);
        }
    }

    public static void main(String[] args) {
        VoucherConfigureRo ro = new VoucherConfigureRo();
        ro.setVoucherTypes("1:1,2:3,3");
        Map<Long, VoucherTypeWithQuantity> result = ro.getVoucherTypeWithQuantity();
        for (VoucherTypeWithQuantity obj : result.values()) {
            System.out.println(obj.toString());
        }
        ro.removeVoucherType(1L);
        System.out.println(ro.voucherTypes);
        ro.addVoucherTypes(100L, 2);
        System.out.println(ro.voucherTypes);
        ro.addVoucherTypes(1L, 2);
        System.out.println(ro.voucherTypes);
        ro.addVoucherTypes(1L, 20);
        System.out.println(ro.voucherTypes);
    }
}

