/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.spring;

import com.depotnearby.common.util.SpringContextUtil;
import com.depotnearby.exception.CommonException;
import com.depotnearby.service.MQService;
import com.depotnearby.vo.mq.MQMessage;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.codelogger.utils.CollectionUtils;
import org.codelogger.utils.ValueUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionStatus;

public class DepotnearbyTransactionManager
extends JpaTransactionManager
implements ApplicationEventPublisherAware {
    private static final Logger logger = LoggerFactory.getLogger(DepotnearbyTransactionManager.class);
    protected static ApplicationEventPublisher applicationEventPublisher;
    public static final ThreadLocal<List<ApplicationEvent>> events;
    public static final ThreadLocal<List<Task>> tasks;
    public static final ThreadLocal<List<MQMessage>> mqMsgs;
    public static final ThreadLocal<Boolean> inTransactions;

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        DepotnearbyTransactionManager.applicationEventPublisher = applicationEventPublisher;
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) {
        super.doBegin(transaction, definition);
        inTransactions.set(true);
    }

    protected void doCommit(DefaultTransactionStatus status) {
        List<Task> tasks;
        List<MQMessage> messages;
        super.doCommit(status);
        boolean isDebugEnabled = logger.isDebugEnabled();
        List<ApplicationEvent> list = events.get();
        if (list != null && !list.isEmpty()) {
            for (ApplicationEvent event : list) {
                if (isDebugEnabled) {
                    logger.debug("applicationEventPublisher.publishEvent {}, hashcode {},ts {}", new Object[]{event.getClass().getCanonicalName(), event.hashCode(), event.getTimestamp()});
                }
                applicationEventPublisher.publishEvent(event);
            }
            list.clear();
        }
        if (CollectionUtils.isNotEmpty(messages = mqMsgs.get())) {
            MQService mqService = DepotnearbyTransactionManager.getMQService();
            for (MQMessage message : messages) {
                try {
                    mqService.sendMessage(message);
                }
                catch (Exception e) {
                    logger.warn("Send message:{} to '{}' failed.", new Object[]{message.getQueueName(), message.getData(), e});
                }
            }
            messages.clear();
        }
        if (CollectionUtils.isNotEmpty(tasks = DepotnearbyTransactionManager.tasks.get())) {
            for (Task task : tasks) {
                try {
                    task.justDoIt();
                }
                catch (Throwable e) {
                    logger.warn("Do task failed.", e);
                }
            }
            tasks.clear();
        }
        inTransactions.set(false);
    }

    protected void doRollback(DefaultTransactionStatus status) {
        List<Task> tasks;
        List<MQMessage> messages;
        super.doRollback(status);
        List<ApplicationEvent> list = events.get();
        if (list != null && !list.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("rooback && clear event");
            }
            list.clear();
        }
        if (CollectionUtils.isNotEmpty(messages = mqMsgs.get())) {
            messages.clear();
        }
        if (CollectionUtils.isNotEmpty(tasks = DepotnearbyTransactionManager.tasks.get())) {
            tasks.clear();
        }
        inTransactions.set(false);
    }

    public static void publishEvent(ApplicationEvent event) {
        Boolean transFlag = inTransactions.get();
        if (transFlag != null && transFlag.booleanValue()) {
            List<ApplicationEvent> list = events.get();
            if (list == null) {
                list = new ArrayList<ApplicationEvent>();
                events.set(list);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("thread is in Transcation send push envet to list");
            }
            list.add(event);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("thread is not in Transcation send event now! applicationEventPublisher is : {} event is:{} ", (Object)applicationEventPublisher, (Object)event);
            }
            applicationEventPublisher.publishEvent(event);
        }
    }

    public static void doWhenTransactionalSuccess(Task task) {
        if (task == null) {
            return;
        }
        Boolean transFlag = inTransactions.get();
        if (ValueUtils.getValue((Boolean)transFlag).booleanValue()) {
            ArrayList tasks = DepotnearbyTransactionManager.tasks.get();
            if (tasks == null) {
                tasks = Lists.newArrayList();
            }
            tasks.add(task);
            DepotnearbyTransactionManager.tasks.set(tasks);
        } else {
            task.justDoIt();
        }
    }

    public static void sendMessage(MQMessage mqMessage) throws CommonException {
        Boolean transFlag = ValueUtils.getValue((Boolean)inTransactions.get());
        if (transFlag.booleanValue()) {
            ArrayList messages = mqMsgs.get();
            if (messages == null) {
                messages = Lists.newArrayList();
                mqMsgs.set(messages);
            }
            messages.add(mqMessage);
        } else {
            DepotnearbyTransactionManager.getMQService().sendMessage(mqMessage);
        }
    }

    private static MQService getMQService() {
        MQService mqService = SpringContextUtil.getBean(MQService.class);
        if (mqService == null) {
            mqService = (MQService)SpringContextUtil.getBean("mqService");
        }
        return mqService;
    }

    static {
        events = new ThreadLocal();
        tasks = new ThreadLocal();
        mqMsgs = new ThreadLocal();
        inTransactions = new ThreadLocal();
    }

    public static interface Task {
        public void justDoIt();
    }
}

