/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.transformer.product;

import com.depotnearby.common.po.depot.DepotPo;
import com.depotnearby.common.po.product.DepotProductPo;
import com.depotnearby.common.po.product.ProductPo;
import com.depotnearby.common.po.product.SaleAreaPo;
import com.depotnearby.common.po.tag.BusinessTagPo;
import com.depotnearby.common.po.tag.PriceTagPo;
import com.depotnearby.common.product.ProductStatus;
import com.depotnearby.common.ro.price.PriceRo;
import com.depotnearby.common.vo.search.ProductIndexVo;
import com.depotnearby.dao.redis.price.PriceRedisDao;
import com.depotnearby.dao.redis.product.ProductRedisDao;
import com.google.common.base.Function;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;

public class DepotProductPoToProductIndexVo
implements Function<DepotProductPo, ProductIndexVo>,
Serializable {
    private ProductRedisDao productRedisDao;
    private PriceRedisDao priceRedisDao;

    public DepotProductPoToProductIndexVo(ProductRedisDao productRedisDao, PriceRedisDao priceRedisDao) {
        this.productRedisDao = productRedisDao;
        this.priceRedisDao = priceRedisDao;
    }

    public ProductIndexVo apply(DepotProductPo dppp) {
        ProductPo po = dppp.getProduct();
        ProductIndexVo vo = null;
        if (po != null) {
            Iterator<Object> iterator;
            StringBuilder sb;
            PriceRo priceRo;
            vo = new ProductIndexVo();
            vo.uid = dppp.getId();
            vo.productId = po.getId();
            vo.centerId = po.getCenterId();
            vo.name = po.getName();
            vo.title = po.getTitle();
            vo.tags = po.getTags();
            vo.brief = po.getBrief();
            vo.salesPrice = dppp.getSalePrice();
            DepotPo depot = dppp.getDepot();
            if (depot != null && (priceRo = this.priceRedisDao.findByAreaNoAndCenterId(depot.getAreaNo(), po.getCenterId())) != null) {
                vo.salesPrice = priceRo.getPrice20();
            }
            vo.marketPrice = po.getMarketPrice();
            vo.suggestedPrice = po.getSuggestedPrice();
            vo.minQuantity = po.getMinQuantity();
            vo.realQuantity = po.getRealQuantity();
            vo.showQuantity = po.getShowQuantity();
            vo.salesVolume = po.getSalesVolume();
            vo.alc = po.getAlc();
            vo.netContent = po.getNetContent();
            vo.wort = po.getWort();
            vo.pageView = po.getPageView();
            vo.priority = po.getPriority();
            Integer n = vo.status = po.isOnLine() ? dppp.getStatus() : po.getStatus();
            if (!Objects.equals(vo.status, ProductStatus.ON_SALE.getValue()) && depot != null && depot.getCompany() != null) {
                vo.status = this.productRedisDao != null && this.productRedisDao.isLockSell(po.getId(), depot.getCompany().getId()) != false ? ProductStatus.ON_SALE.getValue() : vo.status;
            }
            vo.material = po.getMaterial();
            vo.craft = po.getCraft();
            vo.country = po.getCountry();
            vo.origin = po.getOrigin();
            vo.year = po.getYear();
            vo.boost = po.getBoost();
            vo.weight = po.getWeight();
            vo.shelfLife = po.getShelfLife();
            boolean bl = vo.sole = po.getSole() != null && po.getSole() != false;
            if (po.getCategory() != null) {
                vo.categoryId = po.getCategory().getId().toString();
                vo.categoryName = po.getCategory().getName();
            }
            if (po.getBrand() != null) {
                vo.brandId = po.getBrand().getId().toString();
                vo.breanName = po.getBrand().getName();
                vo.breanNameEn = po.getBrand().getNameEn();
            }
            if (po.getFlavor() != null) {
                vo.flavorId = po.getFlavor().getId().toString();
                vo.flavorName = po.getFlavor().getName();
            }
            if (po.getWineType() != null) {
                vo.wineTypeId = po.getWineType().getId().toString();
                vo.wineTypeName = po.getWineType().getName();
            }
            if (CollectionUtils.isNotEmpty(po.getSaleAreas())) {
                sb = new StringBuilder();
                iterator = po.getSaleAreas().iterator();
                while (iterator.hasNext()) {
                    sb.append(((SaleAreaPo)iterator.next()).getId()).append(" ");
                }
                vo.saleAreaIds = sb.toString();
            }
            if (CollectionUtils.isNotEmpty(po.getBusinessTags())) {
                sb = new StringBuilder();
                iterator = po.getBusinessTags().iterator();
                while (iterator.hasNext()) {
                    sb.append(((BusinessTagPo)iterator.next()).getId()).append(" ");
                }
                vo.businessTagIds = sb.toString();
            }
            if (CollectionUtils.isNotEmpty(po.getPriceTags())) {
                sb = new StringBuilder();
                iterator = po.getPriceTags().iterator();
                while (iterator.hasNext()) {
                    sb.append(((PriceTagPo)iterator.next()).getId()).append(" ");
                }
                vo.priceTagIds = sb.toString();
            }
            vo.depotId = depot == null ? null : depot.getId();
        }
        return vo;
    }
}

