/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.transformer.product;

import com.depotnearby.common.po.product.ProductPo;
import com.depotnearby.common.po.product.SaleAreaPo;
import com.depotnearby.common.po.tag.BusinessTagPo;
import com.depotnearby.common.po.tag.PriceTagPo;
import com.depotnearby.common.vo.search.ProductIndexVo;
import com.google.common.base.Function;
import java.io.Serializable;
import java.util.Iterator;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductPoToProductIndexVo
implements Function<ProductPo, ProductIndexVo>,
Serializable {
    private Logger logger = LoggerFactory.getLogger(ProductPoToProductIndexVo.class);

    public ProductIndexVo apply(ProductPo po) {
        this.logger.info(po.toString());
        ProductIndexVo vo = null;
        if (po != null) {
            Iterator<Object> iterator;
            StringBuffer sb;
            vo = new ProductIndexVo();
            vo.uid = po.getId();
            vo.productId = po.getId();
            vo.centerId = po.getCenterId();
            vo.name = po.getName();
            vo.preSale = po.getPreSale();
            vo.title = po.getTitle();
            vo.tags = po.getTags();
            vo.brief = po.getBrief();
            vo.salesPrice = po.getSalesPrice();
            vo.marketPrice = po.getMarketPrice();
            vo.suggestedPrice = po.getSuggestedPrice();
            vo.minQuantity = po.getMinQuantity();
            vo.realQuantity = po.getRealQuantity();
            vo.showQuantity = po.getShowQuantity();
            vo.salesVolume = po.getSalesPrice();
            vo.alc = po.getAlc();
            vo.netContent = po.getNetContent();
            vo.wort = po.getWort();
            vo.pageView = po.getPageView();
            vo.status = po.getStatus();
            vo.material = po.getMaterial();
            vo.craft = po.getCraft();
            vo.country = po.getCountry();
            vo.origin = po.getOrigin();
            vo.year = po.getYear();
            vo.boost = po.getBoost();
            vo.weight = po.getWeight();
            vo.shelfLife = po.getShelfLife();
            boolean bl = vo.sole = po.getSole() == null ? false : po.getSole();
            if (po.getCategory() != null) {
                vo.categoryId = po.getCategory().getId().toString();
                vo.categoryName = po.getCategory().getName();
            }
            if (po.getBrand() != null) {
                vo.brandId = po.getBrand().getId().toString();
                vo.breanName = po.getBrand().getName();
                vo.breanNameEn = po.getBrand().getNameEn();
            }
            if (po.getFlavor() != null) {
                vo.flavorId = po.getFlavor().getId().toString();
                vo.flavorName = po.getFlavor().getName();
            }
            if (po.getWineType() != null) {
                vo.wineTypeId = po.getWineType().getId().toString();
                vo.wineTypeName = po.getWineType().getName();
            }
            if (CollectionUtils.isNotEmpty(po.getSaleAreas())) {
                sb = new StringBuffer();
                iterator = po.getSaleAreas().iterator();
                while (iterator.hasNext()) {
                    sb.append(((SaleAreaPo)iterator.next()).getId()).append(" ");
                }
                vo.saleAreaIds = sb.toString();
            }
            if (CollectionUtils.isNotEmpty(po.getBusinessTags())) {
                sb = new StringBuffer();
                iterator = po.getBusinessTags().iterator();
                while (iterator.hasNext()) {
                    sb.append(((BusinessTagPo)iterator.next()).getId()).append(" ");
                }
                vo.businessTagIds = sb.toString();
            }
            if (CollectionUtils.isNotEmpty(po.getPriceTags())) {
                sb = new StringBuffer();
                iterator = po.getPriceTags().iterator();
                while (iterator.hasNext()) {
                    sb.append(((PriceTagPo)iterator.next()).getId()).append(" ");
                }
                vo.priceTagIds = sb.toString();
            }
        }
        if (po.getProductBusiness() != null) {
            vo.businessId = po.getProductBusiness().getId().toString();
            vo.businessName = po.getProductBusiness().getBusinessName();
        }
        if (po.getProductSeries() != null) {
            vo.productSeriesId = po.getProductSeries().getId().toString();
            vo.productSeriesName = po.getProductSeries().getSerialName();
        }
        return vo;
    }
}

