/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.transformer.product;

import com.depotnearby.common.ro.product.DepotProductRo;
import com.depotnearby.common.ro.product.ProductRo;
import com.depotnearby.common.vo.order.CreateOrderItemVo;
import com.depotnearby.common.vo.product.ProductWithDepotVo;
import com.depotnearby.exception.CommonRuntimeException;
import com.google.common.base.Function;
import java.io.Serializable;

public class ProductWithDepotVoToCreateOrderItemVo
implements Function<ProductWithDepotVo, CreateOrderItemVo>,
Serializable {
    boolean withDepot;
    boolean useDepotPrice;
    boolean useDepotStock;

    public CreateOrderItemVo apply(ProductWithDepotVo inVo) {
        CreateOrderItemVo vo = null;
        ProductRo ro = inVo.getProductRo();
        if (ro == null) {
            throw new CommonRuntimeException("\u5546\u54c1\u4e0d\u5b58\u5728\uff01", 3400);
        }
        vo = new CreateOrderItemVo();
        vo.setProductId(ro.getId());
        vo.setCenterId(ro.getCenterId());
        vo.setName(ro.getName());
        vo.setCanBuy(ro.isOnLine());
        vo.setMaxQuantity(ro.getMaxQuantity());
        vo.setMinQuantity(ro.getMinQuantity());
        vo.setBuyLimitPeriod(ro.getBuyLimitPeriod());
        vo.setSaleAreaIds(ro.getSaleAreaIds());
        vo.setProductLogo(ro.getLogo());
        if (ro.getSalesPrice() != null) {
            vo.setPrice(ro.getSalesPrice());
        }
        vo.setShowQuantity(ro.getShowQuantity());
        vo.setQuantity(inVo.getQuantity());
        vo.setCategoryId(ro.getCategoryId() == null ? 0 : ro.getCategoryId());
        DepotProductRo depotRo = inVo.getDepotProductRo();
        vo.setPrice(depotRo.getSalePrice());
        vo.setDepotPrice(depotRo.getDepotPrice());
        vo.setCostPrice(depotRo.getCostPrice());
        vo.setShowQuantity(depotRo.getShowQuantity());
        vo.setPreSale(ro.getPreSale());
        return vo;
    }
}

