/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.transformer.product;

import com.depotnearby.common.product.ProductStatus;
import com.depotnearby.common.ro.product.DepotProductRo;
import com.depotnearby.common.ro.product.ProductRo;
import com.depotnearby.common.vo.product.ProductDetailVo;
import com.depotnearby.common.vo.product.ProductProperty;
import com.depotnearby.common.vo.product.ProductWithDepotVo;
import com.google.common.base.Function;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.codelogger.utils.ValueUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductWithDepotVoToProductDetailVo
implements Function<ProductWithDepotVo, ProductDetailVo>,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(ProductWithDepotVoToProductDetailVo.class);
    static NumberFormat alcFormat = null;
    boolean withDepot;
    boolean useDepotPrice;
    boolean useDepotStock;

    public static String clearUpImages(String s) {
        String result = s;
        if (result != null) {
            if ((result = result.replaceAll("\\s+", "").replaceAll("[,]+", ",")).endsWith(",")) {
                result = StringUtils.removeEnd((String)result, (String)",");
            }
            if (result.startsWith(",")) {
                result = StringUtils.removeStart((String)result, (String)",");
            }
        }
        return result;
    }

    public ProductWithDepotVoToProductDetailVo(boolean withDepot, boolean useDepotPrice, boolean useDepotStock) {
        this.withDepot = withDepot;
        this.useDepotPrice = useDepotPrice;
        this.useDepotStock = useDepotStock;
    }

    public ProductDetailVo apply(ProductWithDepotVo inVo) {
        ProductDetailVo vo = null;
        ProductRo ro = inVo.getProductRo();
        DepotProductRo depotProductRo = inVo.getDepotProductRo();
        if (ro != null) {
            vo = new ProductDetailVo();
            vo.id = ro.getId();
            vo.name = ro.getName();
            vo.brief = ro.getBrief();
            vo.logo = ro.getLogo();
            vo.salesPrice = depotProductRo.getSalePrice();
            vo.suggestPrice = this.parsePrice(ro.getSuggestedPrice());
            vo.marketPrice = this.parsePrice(depotProductRo.getMarketPrice());
            vo.showQuantity = ValueUtils.getValue((Integer)depotProductRo.getShowQuantity()) > 0 ? ValueUtils.getValue((Integer)depotProductRo.getShowQuantity()) : 0;
            vo.tags = ro.getTags();
            vo.images = ProductWithDepotVoToProductDetailVo.clearUpImages(ro.getImages());
            vo.introImages = ProductWithDepotVoToProductDetailVo.clearUpImages(ro.getIntroImages());
            vo.minQuantity = ro.getMinQuantity() == null ? 1 : ro.getMinQuantity();
            vo.status = ro.isOnLine() ? ProductStatus.ON_SALE.getValue() : ProductStatus.OFF_SALE.getValue();
            ArrayList<ProductProperty> properties = new ArrayList<ProductProperty>();
            if (StringUtils.isNotBlank((CharSequence)ro.getStandard())) {
                properties.add(new ProductProperty("\u6574\u4ef6\u89c4\u683c", ro.getStandard() + "\u74f6"));
            }
            if (ro.getCategoryId() != null) {
                int categoryId = ro.getCategoryId();
                switch (categoryId) {
                    case 1: {
                        if (StringUtils.isNotBlank((CharSequence)ro.getFlavorName())) {
                            properties.add(new ProductProperty("\u9999\u578b", ro.getFlavorName()));
                        }
                        if (ro.getAlc() != null && ro.getAlc() > 0) {
                            properties.add(new ProductProperty("\u5ea6\u6570", alcFormat.format(Double.valueOf(ro.getAlc().intValue()) / 10.0) + "\u00b0"));
                        }
                        if (ro.getNetContent() != null && ro.getNetContent() > 0) {
                            if (ro.getNetContent() > 1000) {
                                properties.add(new ProductProperty("\u51c0\u542b\u91cf", alcFormat.format(Double.valueOf(ro.getNetContent().intValue()) / 1000.0) + "l"));
                            } else {
                                properties.add(new ProductProperty("\u51c0\u542b\u91cf", ro.getNetContent().toString() + "ml"));
                            }
                        }
                        if (StringUtils.isNotBlank((CharSequence)ro.getOrigin())) {
                            properties.add(new ProductProperty("\u5546\u54c1\u4ea7\u5730", ro.getOrigin()));
                        }
                        if (StringUtils.isNotBlank((CharSequence)ro.getMaterial())) {
                            properties.add(new ProductProperty("\u539f\u6599", ro.getMaterial()));
                        }
                        if (StringUtils.isNotBlank((CharSequence)ro.getCraft())) {
                            properties.add(new ProductProperty("\u5236\u4f5c\u5de5\u827a", ro.getCraft()));
                        }
                        if (StringUtils.isNotBlank((CharSequence)ro.getBrandName())) {
                            properties.add(new ProductProperty("\u54c1\u724c", ro.getBrandName()));
                        }
                        if (StringUtils.isNotBlank((CharSequence)ro.getProductEnterprise())) {
                            properties.add(new ProductProperty("\u751f\u4ea7\u4f01\u4e1a", ro.getProductEnterprise()));
                        }
                        if (!StringUtils.isNotBlank((CharSequence)ro.getProductSeriesName())) break;
                        properties.add(new ProductProperty("\u7cfb\u5217", ro.getProductSeriesName()));
                        break;
                    }
                    case 2: {
                        if (StringUtils.isNotBlank((CharSequence)ro.getCountry())) {
                            properties.add(new ProductProperty("\u539f\u4ea7\u56fd", ro.getCountry()));
                        }
                        if (StringUtils.isNotBlank((CharSequence)ro.getBrandName())) {
                            properties.add(new ProductProperty("\u54c1\u724c", ro.getBrandName()));
                        }
                        if (ro.getAlc() != null && ro.getAlc() > 0) {
                            properties.add(new ProductProperty("\u5ea6\u6570", alcFormat.format(Double.valueOf(ro.getAlc().intValue()) / 10.0) + "\u00b0"));
                        }
                        if (ro.getNetContent() != null && ro.getNetContent() > 0) {
                            if (ro.getNetContent() > 1000) {
                                properties.add(new ProductProperty("\u51c0\u542b\u91cf", alcFormat.format(Double.valueOf(ro.getNetContent().intValue()) / 1000.0) + "l"));
                            } else {
                                properties.add(new ProductProperty("\u51c0\u542b\u91cf", ro.getNetContent().toString() + "ml"));
                            }
                        }
                        if (StringUtils.isNotBlank((CharSequence)ro.getOrigin())) {
                            properties.add(new ProductProperty("\u5546\u54c1\u4ea7\u5730", ro.getOrigin()));
                        }
                        if (StringUtils.isNotBlank((CharSequence)ro.getMaterial())) {
                            properties.add(new ProductProperty("\u8461\u8404\u54c1\u79cd", ro.getMaterial()));
                        }
                        if (ro.getYear() != null) {
                            properties.add(new ProductProperty("\u8461\u8404\u5e74\u4efd", ro.getYear().toString()));
                        }
                        if (StringUtils.isNotBlank((CharSequence)ro.getShelfLife())) {
                            properties.add(new ProductProperty("\u4fdd\u8d28\u671f", ro.getShelfLife()));
                        }
                        if (!StringUtils.isNotBlank((CharSequence)ro.getProductSeriesName())) break;
                        properties.add(new ProductProperty("\u7cfb\u5217", ro.getProductSeriesName()));
                        break;
                    }
                    case 3: {
                        if (ro.getAlc() != null && ro.getAlc() > 0) {
                            properties.add(new ProductProperty("\u5ea6\u6570", alcFormat.format(Double.valueOf(ro.getAlc().intValue()) / 10.0) + "\u00b0"));
                        }
                        if (ro.getNetContent() != null && ro.getNetContent() > 0) {
                            if (ro.getNetContent() > 1000) {
                                properties.add(new ProductProperty("\u51c0\u542b\u91cf", alcFormat.format(Double.valueOf(ro.getNetContent().intValue()) / 1000.0) + "l"));
                            } else {
                                properties.add(new ProductProperty("\u51c0\u542b\u91cf", ro.getNetContent().toString() + "ml"));
                            }
                        }
                        if (StringUtils.isNotBlank((CharSequence)ro.getMaterial())) {
                            properties.add(new ProductProperty("\u539f\u6599", ro.getMaterial()));
                        }
                        if (StringUtils.isNotBlank((CharSequence)ro.getCraft())) {
                            properties.add(new ProductProperty("\u5236\u4f5c\u5de5\u827a", ro.getCraft()));
                        }
                        if (StringUtils.isNotBlank((CharSequence)ro.getProductSeriesName())) {
                            properties.add(new ProductProperty("\u7cfb\u5217", ro.getProductSeriesName()));
                        }
                        if (StringUtils.isNotBlank((CharSequence)ro.getBrandName())) {
                            properties.add(new ProductProperty("\u54c1\u724c", ro.getBrandName()));
                        }
                        if (StringUtils.isNotBlank((CharSequence)ro.getShelfLife())) {
                            properties.add(new ProductProperty("\u4fdd\u8d28\u671f", ro.getShelfLife()));
                        }
                        if (!StringUtils.isNotBlank((CharSequence)ro.getHealthWineType())) break;
                        properties.add(new ProductProperty("\u4fdd\u5065\u9152\u5206\u7c7b", ro.getHealthWineType()));
                        break;
                    }
                    case 4: {
                        if (StringUtils.isNotBlank((CharSequence)ro.getCountry())) {
                            properties.add(new ProductProperty("\u539f\u4ea7\u56fd", ro.getCountry()));
                        }
                        if (ro.getAlc() != null && ro.getAlc() > 0) {
                            properties.add(new ProductProperty("\u5ea6\u6570", alcFormat.format(Double.valueOf(ro.getAlc().intValue()) / 10.0) + "\u00b0"));
                        }
                        if (ro.getWort() != null && ro.getWort() > 0) {
                            properties.add(new ProductProperty("\u539f\u9ea6\u6c41\u6d53\u5ea6", alcFormat.format(Double.valueOf(ro.getWort().intValue()) / 10.0) + "\u00b0"));
                        }
                        if (ro.getNetContent() != null && ro.getNetContent() > 0) {
                            if (ro.getNetContent() > 1000) {
                                properties.add(new ProductProperty("\u51c0\u542b\u91cf", alcFormat.format(Double.valueOf(ro.getNetContent().intValue()) / 1000.0) + "l"));
                            } else {
                                properties.add(new ProductProperty("\u51c0\u542b\u91cf", ro.getNetContent().toString() + "ml"));
                            }
                        }
                        if (StringUtils.isNotBlank((CharSequence)ro.getMaterial())) {
                            properties.add(new ProductProperty("\u539f\u6599", ro.getMaterial()));
                        }
                        if (StringUtils.isNotBlank((CharSequence)ro.getCraft())) {
                            properties.add(new ProductProperty("\u5236\u4f5c\u5de5\u827a", ro.getCraft()));
                        }
                        if (!StringUtils.isNotBlank((CharSequence)ro.getShelfLife())) break;
                        properties.add(new ProductProperty("\u4fdd\u8d28\u671f", ro.getShelfLife()));
                        break;
                    }
                    default: {
                        if (StringUtils.isNotBlank((CharSequence)ro.getBrandName())) {
                            properties.add(new ProductProperty("\u54c1\u724c", ro.getBrandName()));
                        }
                        if (StringUtils.isNotBlank((CharSequence)ro.getCountry())) {
                            properties.add(new ProductProperty("\u539f\u4ea7\u56fd", ro.getCountry()));
                        }
                        if (ro.getAlc() != null && ro.getAlc() > 0) {
                            properties.add(new ProductProperty("\u5ea6\u6570", alcFormat.format(Double.valueOf(ro.getAlc().intValue()) / 10.0) + "\u00b0"));
                        }
                        if (ro.getNetContent() != null && ro.getNetContent() > 0) {
                            if (ro.getNetContent() > 1000) {
                                properties.add(new ProductProperty("\u51c0\u542b\u91cf", alcFormat.format(Double.valueOf(ro.getNetContent().intValue()) / 1000.0) + "l"));
                            } else {
                                properties.add(new ProductProperty("\u51c0\u542b\u91cf", ro.getNetContent().toString() + "ml"));
                            }
                        }
                        if (StringUtils.isNotBlank((CharSequence)ro.getMaterial())) {
                            properties.add(new ProductProperty("\u539f\u6599", ro.getMaterial()));
                        }
                        if (!StringUtils.isNotBlank((CharSequence)ro.getShelfLife())) break;
                        properties.add(new ProductProperty("\u4fdd\u8d28\u671f", ro.getShelfLife()));
                    }
                }
            }
            vo.properties = properties;
            logger.info("withDepot && (useDepotPrice || useDepotStock) is {}", (Object)(this.withDepot && (this.useDepotPrice || this.useDepotStock) ? 1 : 0));
        }
        if (vo != null && ValueUtils.getValue((Boolean)inVo.getOffSale()).booleanValue()) {
            vo.status = ProductStatus.OFF_SALE.getValue();
        }
        vo.preSale = ro.getPreSale();
        vo.productBusinessId = ro.getProductBusinessId();
        vo.canBuy = inVo.getCanBuy();
        vo.standard = null != ro.getStandard() ? ro.getStandard() : "1";
        return vo;
    }

    int parsePrice(Integer price) {
        return ValueUtils.getValue((Integer)price) / 100 * 100;
    }

    static {
        alcFormat = NumberFormat.getInstance();
        alcFormat.setMaximumFractionDigits(1);
    }
}

