/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.transformer.product;

import com.depotnearby.common.product.ProductStatus;
import com.depotnearby.common.ro.product.DepotProductRo;
import com.depotnearby.common.ro.product.ProductRo;
import com.depotnearby.common.vo.product.ProductListItemVo;
import com.depotnearby.common.vo.product.ProductWithDepotVo;
import com.google.common.base.Function;
import java.io.Serializable;
import org.codelogger.utils.ValueUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductWithDepotVoToProductListItemVo
implements Function<ProductWithDepotVo, ProductListItemVo>,
Serializable {
    protected static final Logger logger = LoggerFactory.getLogger(ProductWithDepotVoToProductListItemVo.class);
    boolean withDepot;
    boolean useDepotPrice;
    boolean useDepotStock;

    public ProductWithDepotVoToProductListItemVo(boolean withDepot, boolean useDepotPrice, boolean useDepotStock) {
        this.withDepot = withDepot;
        this.useDepotPrice = useDepotPrice;
        this.useDepotStock = useDepotStock;
    }

    public ProductListItemVo apply(ProductWithDepotVo inVo) {
        ProductListItemVo vo = null;
        ProductRo ro = inVo.getProductRo();
        DepotProductRo depotProductRo = inVo.getDepotProductRo();
        if (ro != null) {
            vo = new ProductListItemVo();
            vo.id = ro.getId();
            vo.name = ro.getName();
            vo.logo = ro.getLogo();
            vo.suggestPrice = Math.max(vo.suggestPrice, depotProductRo.getSuggestPrice());
            vo.salesPrice = ValueUtils.getValue((Integer)depotProductRo.getSalePrice());
            vo.preSale = ro.getPreSale();
            vo.tags = ro.getTags();
            vo.brief = ro.getBrief();
            vo.standard = ro.getStandard();
            vo.productBusinessId = ro.getProductBusinessId();
            vo.minQuantity = ro.getMinQuantity() == null ? 1 : ro.getMinQuantity();
            vo.status = ro.getStatus() == null ? 0 : ro.getStatus();
            vo.categoryId = ro.getCategoryId() == null ? 0 : ro.getCategoryId();
            vo.salePromotion = inVo.getSalePromotion();
            int n = vo.showQuantity = ValueUtils.getValue((Integer)depotProductRo.getShowQuantity()) > 0 ? ValueUtils.getValue((Integer)depotProductRo.getShowQuantity()) : 0;
            if (this.withDepot && (this.useDepotPrice || this.useDepotStock)) {
                if (depotProductRo == null || !depotProductRo.isPriceValid()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("depot product is null or price invalid , depotProductRo: {},", (Object)depotProductRo);
                    }
                    return null;
                }
                if (ro.isOnLine()) {
                    vo.status = depotProductRo.isOnLine() ? ProductStatus.ON_SALE.getValue() : ProductStatus.OFF_SALE.getValue();
                }
                if (this.useDepotPrice) {
                    vo.salesPrice = ValueUtils.getValue((Integer)depotProductRo.getSalePrice());
                    vo.suggestPrice = Math.max(vo.suggestPrice, depotProductRo.getSuggestPrice());
                }
                vo.showQuantity = this.useDepotStock ? ValueUtils.getValue((Integer)depotProductRo.getShowQuantity()).intValue() : ValueUtils.getValue((Integer)ro.getShowQuantity()).intValue();
                vo.showQuantity = vo.showQuantity > 0 ? vo.showQuantity : 0;
            }
        }
        return vo;
    }

    Integer parsePrice(Integer price) {
        return price == null ? null : Integer.valueOf(price / 100 * 100);
    }
}

