/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.util;

import com.depotnearby.common.util.RedisUtil;
import com.depotnearby.exception.CommonException;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPool;

public class DistributionUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doLock(String lockName, DoLockHandler<T> handler, int lockMaxTimeInSecond) throws CommonException {
        ShardedJedisPool jedisPool = RedisUtil.getJedisPool();
        ShardedJedis jedis = null;
        boolean isGetLock = false;
        try {
            jedis = jedisPool.getResource();
            String tsStr = String.valueOf(System.currentTimeMillis());
            boolean bl = isGetLock = jedis.setnx(lockName, tsStr) > 0L;
            if (isGetLock) {
                jedis.setex(lockName, lockMaxTimeInSecond, tsStr);
            }
            T t = handler.handle(isGetLock);
            return t;
        }
        finally {
            if (jedis != null) {
                if (isGetLock) {
                    jedis.del(lockName);
                }
                jedisPool.returnResource(jedis);
            }
        }
    }

    public static interface DoLockHandler<T> {
        public T handle(boolean var1) throws CommonException;
    }
}

