/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;

public class ExternalizationHelper {
    public static final int MAX_UTF = 60000;

    public static final String readString(ObjectInput in) throws IOException {
        if (!in.readBoolean()) {
            return null;
        }
        return in.readUTF();
    }

    public static final void writeString(ObjectOutput out, String s) throws IOException {
        out.writeBoolean(s != null);
        if (s != null) {
            out.writeUTF(s);
        }
    }

    public static final void writeBigDecimal6(ObjectOutput out, BigDecimal value) throws IOException {
        ExternalizationHelper.writeBigDecimal(out, value, 6);
    }

    public static final BigDecimal readBigDecimal6(ObjectInput in) throws IOException {
        return ExternalizationHelper.readBigDecimal(in, 6);
    }

    public static final void writeBigDecimal(ObjectOutput out, BigDecimal value, int pos) throws IOException {
        out.writeBoolean(value != null);
        if (value != null) {
            out.writeInt(value.movePointRight(pos).intValue());
        }
    }

    public static final BigDecimal readBigDecimal(ObjectInput in, int pos) throws IOException {
        if (!in.readBoolean()) {
            return null;
        }
        return new BigDecimal(in.readInt()).movePointLeft(pos);
    }

    public static final Integer readInteger(ObjectInput in) throws IOException {
        if (!in.readBoolean()) {
            return null;
        }
        return in.readInt();
    }

    public static final void writeInteger(ObjectOutput out, Integer i) throws IOException {
        out.writeBoolean(i != null);
        if (i != null) {
            out.writeInt(i);
        }
    }

    public static final Timestamp readSqlTimestamp(ObjectInput in) throws IOException {
        if (!in.readBoolean()) {
            return null;
        }
        return new Timestamp(in.readLong());
    }

    public static final void writeSqlTimestamp(ObjectOutput out, Timestamp ts) throws IOException {
        out.writeBoolean(ts != null);
        if (ts != null) {
            out.writeLong(ts.getTime());
        }
    }

    public static final java.sql.Date readSqlDate(ObjectInput in) throws IOException {
        if (!in.readBoolean()) {
            return null;
        }
        return new java.sql.Date(in.readLong());
    }

    public static final void writeSqlDate(ObjectOutput out, java.sql.Date date) throws IOException {
        out.writeBoolean(date != null);
        if (date != null) {
            out.writeLong(date.getTime());
        }
    }

    public static final Date readDate(ObjectInput in) throws IOException {
        if (!in.readBoolean()) {
            return null;
        }
        return new Date(in.readLong());
    }

    public static final void writeDate(ObjectOutput out, Date date) throws IOException {
        out.writeBoolean(date != null);
        if (date != null) {
            out.writeLong(date.getTime());
        }
    }

    public static final Long readLong(ObjectInput in) throws IOException {
        if (!in.readBoolean()) {
            return null;
        }
        return in.readLong();
    }

    public static final void writeLong(ObjectOutput out, Long i) throws IOException {
        out.writeBoolean(i != null);
        if (i != null) {
            out.writeLong(i);
        }
    }

    public static final byte[] serialize(Externalizable obj) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(bos);
            obj.writeExternal(os);
            os.close();
            return bos.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final Externalizable deserialize(Externalizable obj, byte[] by) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(by);
            ObjectInputStream in = new ObjectInputStream(is);
            obj.readExternal(in);
            in.close();
            return obj;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void main(String[] args) {
        System.out.println(Short.MAX_VALUE);
        System.out.println(new Integer(127).byteValue());
        System.out.println(127);
        System.out.println(Integer.MAX_VALUE);
    }
}

