/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.vo.security;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class SecurityReqVo
implements Comparable<SecurityReqVo> {
    public static final String X_REAL_IP = "X-Real-IP";
    private String uri;
    private String ip;
    private Long timestamp;

    public SecurityReqVo(HttpServletRequest request) {
        String xRealIp = request.getHeader(X_REAL_IP);
        this.ip = StringUtils.isBlank((CharSequence)xRealIp) ? request.getRemoteHost() : xRealIp;
        this.uri = request.getRequestURI();
        this.timestamp = System.currentTimeMillis();
    }

    public SecurityReqVo(String ip, Long timestamp, String uri) {
        this.ip = ip;
        this.timestamp = timestamp;
        this.uri = uri;
    }

    public String toString() {
        return "SecurityReqVo{uri='" + this.uri + '\'' + ", ip='" + this.ip + '\'' + ", timestamp=" + this.timestamp + '}';
    }

    public String getUri() {
        return this.uri;
    }

    public String getIp() {
        return this.ip;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public int compareTo(SecurityReqVo o) {
        return o.getTimestamp().compareTo(this.timestamp);
    }
}

