/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.common.vo.shop;

import com.depotnearby.common.po.shop.ShopDetailPo;
import com.depotnearby.common.shop.AuditRejectReason;
import com.depotnearby.common.shop.AuditStatus;
import com.depotnearby.common.vo.shop.ShopUpdateDetailVo;
import com.google.common.base.Function;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import org.codelogger.utils.CollectionUtils;

public class ShopDetailPoToShopUpdateDetailVo
implements Function<ShopDetailPo, ShopUpdateDetailVo>,
Serializable {
    public ShopUpdateDetailVo apply(ShopDetailPo po) {
        ShopUpdateDetailVo vo = null;
        if (po != null) {
            vo = new ShopUpdateDetailVo();
            vo.setCityId(po.getCity().getId());
            vo.setCityName(po.getCity().getName());
            vo.setDistrictId(po.getDistrict().getId());
            vo.setDistrictName(po.getDistrict().getName());
            vo.setProvinceId(po.getProvince().getId());
            vo.setProvinceName(po.getProvince().getName());
            vo.setDeliveryAddress(po.getDeliveryAddress());
            vo.setAuditStatus(po.getAuditStatus());
            vo.setReason(po.getReason());
            Integer auditStatus = po.getAuditStatus();
            String msg = null;
            if (Objects.equals(auditStatus, AuditStatus.AUDIT_FAILED.getValue())) {
                msg = CollectionUtils.join((Collection)AuditRejectReason.parseRejectReasons((String[])po.getRejectReason().split("\\D")), (String)",");
            } else if (Objects.equals(auditStatus, AuditStatus.NORMAL_AND_NEW_UPDATE_AUDIT_FAILED.getValue())) {
                msg = "\u60a8\u8bf7\u6c42\u66f4\u6539\u6536\u8d27\u5730\u5740\u4e0d\u6210\u529f";
            } else if (Objects.equals(auditStatus, AuditStatus.NORMAL_AND_HAS_NEW_UPDATE_WAIT_FOR_AUDIT.getValue())) {
                msg = "\u8d44\u6599\u6b63\u5728\u5ba1\u6838\u4e2d\uff0c\u8bf7\u8010\u5fc3\u7b49\u5019";
            }
            vo.setRejectReasons(msg);
        }
        return vo;
    }
}

