/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.mysql.account;

import com.depotnearby.bean.PageControl;
import com.depotnearby.common.dao.mysql.CommonManageAbleDao;
import com.depotnearby.common.po.payment.PaymentApplyStatus;
import com.depotnearby.common.vo.ximu.XimuApplyQueryReqVo;
import com.depotnearby.dao.mysql.account.XiMuPaymentApplyDao;
import java.util.List;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.codelogger.utils.CollectionUtils;
import org.springframework.stereotype.Repository;

@Repository
public class XiMuPaymentApplyRepositoryImpl
extends CommonManageAbleDao
implements XiMuPaymentApplyDao {
    @Override
    public PageControl searchXimuApplies(XimuApplyQueryReqVo vo, PageControl pageControl) {
        String sql;
        String countPrefix = "SELECT COUNT(*) ";
        StringBuilder sqlBuilder = new StringBuilder("FROM XiMuPaymentApplyPo xmpa WHERE");
        if (StringUtils.isNotBlank((CharSequence)vo.getCust_tel())) {
            sqlBuilder.append(" xmpa.cust_tel = :cust_tel AND");
        }
        if (vo.getApplyStatus() != null && vo.getApplyStatus() != PaymentApplyStatus.ALL) {
            sqlBuilder.append(" xmpa.paymentApplyStatus = :paymentApplyStatus AND");
        }
        if (vo.getPreApplyStatus() != null && vo.getPreApplyStatus() != PaymentApplyStatus.ALL) {
            sqlBuilder.append(" xmpa.preApplyStatus = :preApplyStatus AND");
        }
        if (CollectionUtils.isNotEmpty(vo.getCityIds())) {
            sqlBuilder.append(" xmpa.shop.city.id IN :cityIds");
        }
        String fixedSql = (sql = sqlBuilder.toString()).endsWith("WHERE") ? StringUtils.substringBeforeLast((String)sql, (String)"WHERE") : sql;
        fixedSql = fixedSql.endsWith("AND") ? StringUtils.substringBeforeLast((String)fixedSql, (String)"AND") : fixedSql;
        Query query = this.getEntityManager().createQuery(fixedSql);
        Query countQuery = this.getEntityManager().createQuery(countPrefix + fixedSql);
        if (StringUtils.isNotBlank((CharSequence)vo.getCust_tel())) {
            query.setParameter("cust_tel", (Object)vo.getCust_tel());
            countQuery.setParameter("cust_tel", (Object)vo.getCust_tel());
        }
        if (vo.getApplyStatus() != null && vo.getApplyStatus() != PaymentApplyStatus.ALL) {
            query.setParameter("paymentApplyStatus", (Object)vo.getApplyStatus());
            countQuery.setParameter("paymentApplyStatus", (Object)vo.getApplyStatus());
        }
        if (vo.getPreApplyStatus() != null && vo.getPreApplyStatus() != PaymentApplyStatus.ALL) {
            query.setParameter("preApplyStatus", (Object)vo.getPreApplyStatus());
            countQuery.setParameter("preApplyStatus", (Object)vo.getPreApplyStatus());
        }
        if (CollectionUtils.isNotEmpty(vo.getCityIds())) {
            query.setParameter("cityIds", vo.getCityIds());
            countQuery.setParameter("cityIds", vo.getCityIds());
        }
        List resultList = query.setFirstResult(pageControl.getBegin()).setMaxResults(pageControl.getPageSize()).getResultList();
        pageControl.setList(resultList);
        pageControl.setCount(Integer.valueOf(countQuery.getSingleResult().toString()).intValue());
        return pageControl;
    }
}

