/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.mysql.dealer;

import com.depotnearby.common.po.price.DealerProductPricePo;
import com.depotnearby.dao.mysql.dealer.DealerProductPriceDao;
import java.util.List;
import javax.transaction.Transactional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
@Transactional
public interface DealerProductPriceRepository
extends JpaRepository<DealerProductPricePo, Long>,
DealerProductPriceDao,
JpaSpecificationExecutor<DealerProductPricePo> {
    @Query(value="select p.id from DealerProductPricePo p where p.productCode = :productCode and p.dealerCode=:dealerCode")
    public List<Long> getIdByAreaCodeAndProduct(@Param(value="productCode") String var1, @Param(value="dealerCode") String var2);

    @Modifying
    @Transactional
    @Query(value="update DealerProductPricePo p set p.price = :price * p.scale where p.productCode = :productCode and p.dealerCode = :dealerCode andp.terminalLevelCode IS NULL and p.terminalCode IS NULL")
    public void modifyDealerPrice(@Param(value="productCode") String var1, @Param(value="dealerCode") String var2, @Param(value="price") Double var3);

    @Modifying
    @Transactional
    @Query(value="update DealerProductPricePo p set p.price = :price * p.scale where p.productCode = :productCode and p.dealerCode = :dealerCode and p.terminalLevelCode = :terminalLevel")
    public void modifyDealerPriceByTerminalLevel(@Param(value="productCode") String var1, @Param(value="dealerCode") String var2, @Param(value="terminalLevel") String var3, @Param(value="price") Double var4);

    @Modifying
    @Transactional
    @Query(value="update DealerProductPricePo p set p.price = :price * p.scale where p.productCode = :productCode and p.dealerCode = :dealerCode and p.terminalCode = :terminalCode")
    public void modifyDealerPriceByTerminal(@Param(value="productCode") String var1, @Param(value="dealerCode") String var2, @Param(value="terminalCode") String var3, @Param(value="price") Double var4);

    @Transactional
    @Query(value="update DealerProductPricePo p set p.putWayStatus = :putWayStatus where p.productCode = :productCode and p.dealerCode = :dealerCode")
    @Modifying
    public void modifyDealerPutWayStatus(@Param(value="productCode") String var1, @Param(value="dealerCode") String var2, @Param(value="putWayStatus") Boolean var3);

    @Transactional
    @Query(value="update DealerProductPricePo p set p.putWayStatus = :putWayStatus where p.productCode = :productCode and p.dealerCode = :dealerCode and p.terminalLevelCode = :terminalLevel")
    @Modifying
    public void modifyDealerPutWayStatusByTerminalLevel(@Param(value="productCode") String var1, @Param(value="dealerCode") String var2, @Param(value="terminalLevel") String var3, @Param(value="putWayStatus") Boolean var4);

    @Transactional
    @Query(value="update DealerProductPricePo p set p.putWayStatus = :putWayStatus where p.productCode = :productCode and p.dealerCode = :dealerCode and p.terminalCode = :terminalCode")
    @Modifying
    public void modifyDealerPutWayStatusByTerminalCode(@Param(value="productCode") String var1, @Param(value="dealerCode") String var2, @Param(value="terminalCode") String var3, @Param(value="putWayStatus") Boolean var4);

    @Transactional
    @Modifying
    @Query(value="delete from DealerProductPricePo p where p.productCode = :productCode and p.dealerCode = :dealerCode")
    public void deleteDealerByProductCode(@Param(value="productCode") String var1, @Param(value="dealerCode") String var2);

    @Transactional
    @Modifying
    @Query(value="delete from DealerProductPricePo p where p.productCode = :productCode and p.dealerCode = :dealerCode and p.terminalLevelCode = :terminalLevel")
    public void deleteDealerByProductCodeByTerminalLevel(@Param(value="productCode") String var1, @Param(value="dealerCode") String var2, @Param(value="terminalLevel") String var3);

    @Transactional
    @Modifying
    @Query(value="delete from DealerProductPricePo p where p.productCode = :productCode and p.dealerCode = :dealerCode and p.terminalCode = :terminalCode")
    public void deleteDealerByProductCodeByTerminalCode(@Param(value="productCode") String var1, @Param(value="dealerCode") String var2, @Param(value="terminalCode") String var3);
}

