/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.mysql.depot;

import com.depotnearby.common.po.CommonAuditStatus;
import com.depotnearby.common.po.CommonStatus;
import com.depotnearby.common.po.depot.DepotPo;
import com.depotnearby.common.po.depot.DepotType;
import com.depotnearby.common.po.organization.CompanyPo;
import com.depotnearby.dao.mysql.depot.DepotDao;
import java.util.Collection;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface DepotRepository
extends JpaRepository<DepotPo, String>,
DepotDao,
JpaSpecificationExecutor<DepotPo> {
    public List<DepotPo> findByName(String var1);

    @Query(value="SELECT id FROM DepotPo d WHERE d.city.id IN :cityIds")
    public List<String> findDepotIdsByCityIds(@Param(value="cityIds") Collection<Integer> var1);

    public List<DepotPo> findByDistrictId(Integer var1);

    public DepotPo findByMcuCode(String var1);

    public List<DepotPo> findByAreaNo(String var1);

    @Query(value="from DepotPo d where d.auditStatus <> :status or d.auditStatus is null")
    public List<DepotPo> findUnAuditDepots(@Param(value="status") CommonAuditStatus var1);

    public List<DepotPo> findByDepotType(DepotType var1);

    public List<DepotPo> findByProvinceIdAndDepotType(Integer var1, DepotType var2);

    @Modifying
    @Query(value="UPDATE DepotPo d SET d.company.id = :companyId WHERE d.city.id IN :cityIds AND d.depotType IN :depotTypes")
    public void changeDepotCompanyByCities(@Param(value="companyId") Long var1, @Param(value="cityIds") List<Integer> var2, @Param(value="depotTypes") List<DepotType> var3);

    public List<DepotPo> findByCompany(CompanyPo var1);

    public List<DepotPo> findByCompanyAndDepotTypeAndEnableStatus(CompanyPo var1, DepotType var2, CommonStatus var3);

    public List<DepotPo> findByDepotTypeAndEnableStatus(DepotType var1, CommonStatus var2);
}

