/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.mysql.depot;

import com.depotnearby.common.dao.mysql.CommonManageAbleDao;
import com.depotnearby.common.po.depot.DepotPo;
import com.depotnearby.common.vo.depot.DepotQueryReqVo;
import com.depotnearby.dao.mysql.depot.DepotDao;
import com.depotnearby.dao.mysql.depot.DepotRepository;
import java.util.ArrayList;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Repository;

@Repository(value="depotRepositoryImpl")
public class DepotRepositoryImpl
extends CommonManageAbleDao
implements DepotDao {
    @Autowired
    private DepotRepository depotRepository;

    @Override
    public Page<DepotPo> searchDepots(final DepotQueryReqVo vo, Pageable pageable) {
        return this.depotRepository.findAll((Specification)new Specification<DepotPo>(){

            public Predicate toPredicate(Root<DepotPo> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                ArrayList<Object> predicates = new ArrayList<Object>();
                if (CollectionUtils.isNotEmpty(vo.getCityIds())) {
                    CriteriaBuilder.In IN = cb.in((Expression)root.get("city").get("id"));
                    for (Integer id : vo.getCityIds()) {
                        IN.value((Object)id);
                    }
                    predicates.add(IN);
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getName())) {
                    predicates.add(cb.like((Expression)root.get("name"), "%" + vo.getName() + "%"));
                }
                if (vo.getDepotType() != null) {
                    predicates.add(cb.equal((Expression)root.get("depotType"), (Object)vo.getDepotType().getValue()));
                }
                if (vo.getEnableStatus() != null) {
                    predicates.add(cb.equal((Expression)root.get("enableStatus"), (Object)vo.getEnableStatus().getValue()));
                }
                if (predicates.size() > 0) {
                    return cb.and(predicates.toArray(new Predicate[predicates.size()]));
                }
                return null;
            }
        }, pageable);
    }
}

