/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.mysql.log;

import com.depotnearby.common.dao.mysql.CommonManageAbleDao;
import com.depotnearby.common.po.log.LogPo;
import com.depotnearby.common.vo.log.LogSearchVo;
import com.depotnearby.dao.mysql.log.LogDao;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository(value="logRepositoryImpl")
public class LogRepositoryImpl
extends CommonManageAbleDao
implements LogDao {
    @Override
    public List<LogPo> findLogs(LogSearchVo vo) {
        ArrayList<Object> predicates = new ArrayList<Object>();
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery criteriaQuery = cb.createQuery(LogPo.class);
        Root form = criteriaQuery.from(LogPo.class);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{vo.getUri()})) {
            System.out.print(vo.getUri());
            predicates.add(cb.like((Expression)form.get("uri"), "%" + vo.getUri() + "%"));
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{vo.getTimeStamp()})) {
            System.out.print(vo.getTimeStamp());
            predicates.add(cb.like((Expression)form.get("timestamp"), "%" + vo.getTimeStamp() + "%"));
        }
        if (CollectionUtils.isNotEmpty(vo.getHttp_methods())) {
            System.out.print(vo.getHttp_methods().toString());
            List<String> http_methods = vo.getHttp_methods();
            CriteriaBuilder.In in = cb.in((Expression)form.get("http_method"));
            for (int i = 0; i < http_methods.size(); ++i) {
                in.value((Object)http_methods.get(i));
            }
            predicates.add(in);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{vo.getUser()})) {
            System.out.print(vo.getUser());
            predicates.add(cb.equal((Expression)form.get("user"), (Object)vo.getUser()));
        }
        criteriaQuery.where(predicates.toArray(new Predicate[0]));
        TypedQuery q = this.getEntityManager().createQuery(criteriaQuery);
        List result = q.getResultList();
        return result;
    }
}

