/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.mysql.order;

import com.depotnearby.common.dao.mysql.CommonManageAbleDao;
import com.depotnearby.common.vo.order.AfterSaleOrderVo;
import com.depotnearby.common.vo.order.DeliveryOrderResVo;
import com.depotnearby.common.vo.order.DeliveryOrderVo;
import com.depotnearby.common.vo.product.ReplenishProductVo;
import com.depotnearby.dao.mysql.order.DeliveryOrderDao;
import java.util.List;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class DeliveryOrderRepositoryImpl
extends CommonManageAbleDao
implements DeliveryOrderDao {
    @Override
    public List<DeliveryOrderVo> findDeliveryOrderVosByShopIdAndStatus(Long shopId, Integer deliveryStatus) {
        StringBuffer sb = new StringBuffer();
        sb.append("select b.hid id , group_concat(a.images) as image,group_concat(a.productid) as productId,group_concat(a.`name`) as productName,b.payamount,b.orderId,b.orderCode from ");
        sb.append("(select p.images,i.productid,p.`name`,i.deliveryOrderId  from delivery_item as i LEFT JOIN pro_product as p on i.productid = p.id) a,");
        sb.append("(select he.payamount,he.orderId,he.hid,he.ordercode from delivery_item as i,");
        sb.append("(select h.id as hid,h.orderId,d.payamount,d.ordercode from order_detail d,");
        sb.append("(select * from delivery_order where shopid =:shopId and  deliverystatus =:deliveryStatus) ");
        sb.append("as h where d.id = h.orderId) as `he`");
        sb.append("where i.deliveryOrderId=he.hid group by hid) as b where a.deliveryOrderId = b.hid group by b.orderId ORDER BY b.hid DESC");
        Query query = this.getEntityManager().createNativeQuery(sb.toString(), "DeliveryOrderVo").setParameter("shopId", (Object)shopId).setParameter("deliveryStatus", (Object)deliveryStatus);
        return query.getResultList();
    }

    @Override
    public List<AfterSaleOrderVo> findAfterSaleOrderVoByShopId(Long shopId) {
        String sql = "SELECT r.id as orderId, d.payamount as payAmount, d.ordercode as orderCode, GROUP_CONCAT(p.images) as image,GROUP_CONCAT(p.id) AS productId, r.`status`, r.`type` FROM\torder_detail as d,\torder_item as i, pro_product as p, order_apply_refund as r WHERE d.shopid IN (SELECT s.id from shop s where s.cityshopid =:shopId) AND d.`status` IN ('60', '65', '100') and d.id =i.orderId and i.productid = p.id and r.orderId = d.id GROUP BY d.ordercode";
        Query query = this.getEntityManager().createNativeQuery(sql, "AfterSaleOrderVos").setParameter("shopId", (Object)shopId);
        return query.getResultList();
    }

    @Override
    public List<DeliveryOrderVo> findDeliveryOrderVos(Long shopId) {
        String sql = "SELECT d.id as id ,o.id orderId, o.ordercode orderCode, (SELECT s1.mobile from shop s1 where s1.id =o.shopId ) mobile, o.paymenttype paymentType, o.payStatus ,d.createDate , d.deliverystatus deliveryStatus ,d.shopid shopId from delivery_order d LEFT JOIN order_detail o on d.orderId = o.id";
        if (shopId != null) {
            sql = sql + " where d.shopid = " + shopId;
        }
        sql = sql + "  ORDER BY createdate DESC";
        Query query = this.getEntityManager().createNativeQuery(sql, "DeliveryOrderVo2");
        return query.getResultList();
    }

    @Override
    public List<DeliveryOrderVo> findDeliveryOrderVosByShopId(Long shopId) {
        String sql = "SELECT d.id id ,o.buyerid shopId,s.mobile mobile,o.finishTime finishTime from delivery_order d,order_detail o ,shop s where s.id=o.buyerid and d.shopid =:shopId and d.replenish_status = 1 and d.orderId = o.id and o.`status` =100;";
        Query query = this.getEntityManager().createNativeQuery(sql, "DeliveryOrderVo3").setParameter("shopId", (Object)shopId);
        return query.getResultList();
    }

    @Override
    public List<ReplenishProductVo> findReplenishProductVoByShopId(Long shopId) {
        String sql = "SELECT productname name, centerid centerId, SUM(productnumber) quantity FROM delivery_item item WHERE item.deliveryOrderId IN ( SELECT d.id id FROM delivery_order d, order_detail o WHERE d.shopid =:shopId AND d.replenish_status = 1 AND d.orderId = o.id AND o.`status` = 100 ) GROUP BY centerid";
        Query query = this.getEntityManager().createNativeQuery(sql, "ReplenishProductVo").setParameter("shopId", (Object)shopId);
        return query.getResultList();
    }

    @Override
    public void updateDeliveryOrderPoByShopId(Long shopId, Long replenishOrderId) {
        Query query = this.getEntityManager().createNativeQuery("UPDATE delivery_order SET delivery_order.replenish_status = 2 ,delivery_order.replenishorderid =:replenishOrderId   WHERE id IN ( SELECT id FROM ( SELECT d.id id FROM delivery_order d, order_detail o WHERE d.shopid =:shopId AND d.replenish_status = 1 AND d.orderId = o.id AND o.`status` = 100 ) AS temp )").setParameter("shopId", (Object)shopId).setParameter("replenishOrderId", (Object)replenishOrderId);
        query.executeUpdate();
    }

    @Override
    public List<DeliveryOrderResVo> findDeliveryOrderResVosById(Long id) {
        String sql = "SELECT d.id id, o.ordercode orderCode, o.shopId shopId, s.mobile mobile,o.finishtime finishTime from  delivery_order d ,order_detail o,shop s where  d.replenishorderid =:replenishOrderId and d.orderid = o.id AND o.shopid = s.id ";
        Query query = this.getEntityManager().createNativeQuery(sql, "DeliveryOrderResVo").setParameter("replenishOrderId", (Object)id);
        return query.getResultList();
    }

    @Override
    public List<DeliveryOrderResVo> findDeliveryOrderByConditions(String shopId, String name, String startTime, String endTime) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT d.id id, o.ordercode orderCode, o.buyerid shopId, s.mobile mobile, o.finishTime finishTime FROM delivery_order d, order_detail o, shop s WHERE s.id = o.buyerid AND d.replenish_status = 1 AND d.orderId = o.id AND o.`status` = 100");
        if (StringUtils.isNotBlank((CharSequence)shopId)) {
            sb.append(" AND d.shopId=:shopId ");
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            sb.append(" AND s.name=:name");
        }
        if (StringUtils.isNotBlank((CharSequence)startTime)) {
            sb.append("AND d.createdate > str_to_date('");
            sb.append(startTime);
            sb.append("', '%Y-%m-%d %H')");
        }
        if (StringUtils.isNotBlank((CharSequence)endTime)) {
            sb.append("AND d.createdate < str_to_date('");
            sb.append(endTime);
            sb.append("', '%Y-%m-%d %H')");
        }
        Query query = this.getEntityManager().createNativeQuery(sb.toString(), "DeliveryOrderResVo");
        if (StringUtils.isNotBlank((CharSequence)shopId)) {
            query.setParameter("shopId", (Object)shopId);
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            query.setParameter("name", (Object)name);
        }
        return query.getResultList();
    }

    @Override
    public List<ReplenishProductVo> findReplenishProductVosByConditions(String shopId, String name, String startTime, String endTime) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT  item.productname AS name , item.centerid AS centerId ,SUM(item.productnumber) quantity FROM delivery_item item where item.deliveryOrderId IN ( ");
        sb.append("SELECT d.id  FROM delivery_order d, order_detail o, shop s WHERE s.id = o.buyerid AND d.replenish_status = 1 AND d.orderId = o.id AND o.`status` = 100");
        if (StringUtils.isNotBlank((CharSequence)shopId)) {
            sb.append(" AND d.shopId=:shopId ");
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            sb.append(" AND s.name=:name");
        }
        if (StringUtils.isNotBlank((CharSequence)startTime)) {
            sb.append("AND d.createdate > str_to_date('");
            sb.append(startTime);
            sb.append("', '%Y-%m-%d %H')");
        }
        if (StringUtils.isNotBlank((CharSequence)endTime)) {
            sb.append("AND d.createdate < str_to_date('");
            sb.append(endTime);
            sb.append("', '%Y-%m-%d %H')");
        }
        sb.append(" ) GROUP BY item.centerId");
        Query query = this.getEntityManager().createNativeQuery(sb.toString(), "ReplenishProductVo");
        if (StringUtils.isNotBlank((CharSequence)shopId)) {
            query.setParameter("shopId", (Object)shopId);
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            query.setParameter("name", (Object)name);
        }
        return query.getResultList();
    }

    @Override
    public void updateDeliveryOrderPoByPlat(String shopId, String name, String startTime, String endTime, Long replenishorderId) {
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE delivery_order SET replenishorderid =:replenishorderId ,replenish_status =3 where id  IN( SELECT did FROM( ");
        sb.append("SELECT d.id did FROM delivery_order d, order_detail o, shop s WHERE s.id = o.buyerid AND d.replenish_status = 1 AND d.orderId = o.id AND o.`status` = 100 ");
        if (StringUtils.isNotBlank((CharSequence)shopId)) {
            sb.append(" AND d.shopId=:shopId ");
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            sb.append(" AND s.name=:name");
        }
        if (StringUtils.isNotBlank((CharSequence)startTime)) {
            sb.append("AND d.createdate > str_to_date('");
            sb.append(startTime);
            sb.append("', '%Y-%m-%d %H')");
        }
        if (StringUtils.isNotBlank((CharSequence)endTime)) {
            sb.append("AND d.createdate < str_to_date('");
            sb.append(endTime);
            sb.append("', '%Y-%m-%d %H')");
        }
        sb.append(" ) AS temp )");
        Query query = this.getEntityManager().createNativeQuery(sb.toString());
        query.setParameter("replenishorderId", (Object)replenishorderId);
        if (StringUtils.isNotBlank((CharSequence)shopId)) {
            query.setParameter("shopId", (Object)shopId);
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            query.setParameter("name", (Object)name);
        }
        query.executeUpdate();
    }
}

