/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.mysql.order;

import com.depotnearby.common.dao.mysql.CommonManageAbleDao;
import com.depotnearby.common.model.order.INuomiFailedOrderQueryReqVo;
import com.depotnearby.common.po.order.NuomiFailedOrderPo;
import com.depotnearby.dao.mysql.order.NuomiFailedOrderDao;
import com.depotnearby.dao.mysql.order.NuomiFailedOrderRepository;
import com.depotnearby.util.DateTool;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.commons.lang3.StringUtils;
import org.codelogger.utils.ValueUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Repository;

@Repository(value="nuomiFailedOrderRepositoryImpl")
public class NuomiFailedOrderRepositoryImpl
extends CommonManageAbleDao
implements NuomiFailedOrderDao {
    @Autowired
    private NuomiFailedOrderRepository nuomiFailedOrderRepository;

    @Override
    public Page<NuomiFailedOrderPo> searchNuomiFailedOrders(final INuomiFailedOrderQueryReqVo vo, Pageable pageable) {
        return this.nuomiFailedOrderRepository.findAll((Specification)new Specification<NuomiFailedOrderPo>(){

            public Predicate toPredicate(Root<NuomiFailedOrderPo> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                if (ValueUtils.getValue((Long)vo.getNuomiId()) != 0L) {
                    predicates.add(cb.equal((Expression)root.get("id"), (Object)vo.getNuomiId()));
                }
                if (ValueUtils.getValue((Long)vo.getNuomiBuyerId()) != 0L) {
                    predicates.add(cb.equal((Expression)root.get("nuomiBuyerId"), (Object)vo.getNuomiBuyerId()));
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getMobile())) {
                    predicates.add(cb.equal((Expression)root.get("mobile"), (Object)vo.getMobile()));
                }
                if (ValueUtils.getValue((Integer)vo.getStatus()) != 0) {
                    predicates.add(cb.equal((Expression)root.get("status"), (Object)vo.getStatus()));
                }
                if (ValueUtils.getValue((Integer)vo.getType()) != 0) {
                    predicates.add(cb.equal((Expression)root.get("type"), (Object)vo.getType()));
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{vo.getFromTime()})) {
                    Timestamp fromTime = DateTool.getTimestamp((String)vo.getFromTime(), (String)"yyyy-MM-dd");
                    predicates.add(cb.greaterThanOrEqualTo(root.get("createTime").as(Timestamp.class), (Comparable)fromTime));
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{vo.getEndTime()})) {
                    Timestamp endTime = DateTool.getTimestamp((String)vo.getEndTime(), (String)"yyyy-MM-dd");
                    predicates.add(cb.lessThanOrEqualTo(root.get("createTime").as(Timestamp.class), (Comparable)endTime));
                }
                if (predicates.size() > 0) {
                    return cb.and(predicates.toArray(new Predicate[predicates.size()]));
                }
                return null;
            }
        }, pageable);
    }
}

