/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.mysql.order;

import com.depotnearby.common.dao.mysql.CommonManageAbleDao;
import com.depotnearby.common.model.order.IOrderRefundQueryReqVo;
import com.depotnearby.common.po.order.OrderApplyRefundPo;
import com.depotnearby.common.vo.order.AfterSaleOrderVo;
import com.depotnearby.dao.mysql.order.OrderApplyRefundDao;
import com.depotnearby.dao.mysql.order.OrderApplyRefundRepository;
import com.depotnearby.util.DateTool;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.commons.lang3.StringUtils;
import org.codelogger.utils.ValueUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Repository;

@Repository
public class OrderApplyRefundRepositoryImpl
extends CommonManageAbleDao
implements OrderApplyRefundDao {
    @Autowired
    OrderApplyRefundRepository orderApplyRefundRepository;

    @Override
    public Page<OrderApplyRefundPo> searchRefunds(final IOrderRefundQueryReqVo vo, Pageable pageable) {
        return this.orderApplyRefundRepository.findAll((Specification)new Specification<OrderApplyRefundPo>(){

            public Predicate toPredicate(Root<OrderApplyRefundPo> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                if ((long)ValueUtils.getValue((Integer)vo.getType()).intValue() != 0L) {
                    predicates.add(cb.equal((Expression)root.get("type"), (Object)vo.getType()));
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getOrderCode())) {
                    predicates.add(cb.equal((Expression)root.get("orderPo").get("orderCode"), (Object)vo.getOrderCode()));
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{vo.getFromTime()})) {
                    Timestamp fromTime = DateTool.getTimestamp((String)vo.getFromTime(), (String)"yyyy-MM-dd");
                    predicates.add(cb.greaterThanOrEqualTo(root.get("createTime").as(Timestamp.class), (Comparable)fromTime));
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{vo.getEndTime()})) {
                    Timestamp endTime = DateTool.getTimestamp((String)vo.getEndTime(), (String)"yyyy-MM-dd");
                    predicates.add(cb.lessThanOrEqualTo(root.get("createTime").as(Timestamp.class), (Comparable)endTime));
                }
                if (predicates.size() > 0) {
                    return cb.and(predicates.toArray(new Predicate[predicates.size()]));
                }
                return null;
            }
        }, pageable);
    }

    @Override
    public AfterSaleOrderVo findAfterSalebySalesId(Long salesId) {
        String sql = "select r.type,r.reason,r.description,r.images,r.status,d.payamount as payAmount from order_detail as d ,order_apply_refund as r where r.orderId = d.id and r.id = :salesId";
        Query query = this.getEntityManager().createNativeQuery(sql, "orderAfterSaleVo").setParameter("salesId", (Object)salesId);
        AfterSaleOrderVo afterSaleOrderVo = (AfterSaleOrderVo)query.getSingleResult();
        return afterSaleOrderVo;
    }
}

