/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.mysql.order;

import com.depotnearby.common.po.order.OrderPo;
import com.depotnearby.dao.mysql.order.OrderDao;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface OrderRepository
extends JpaRepository<OrderPo, Long>,
OrderDao,
JpaSpecificationExecutor<OrderPo> {
    @Query(value="SELECT COUNT(p) FROM OrderPo p")
    public Integer findAllCount();

    public List<OrderPo> findByStatusOrderByIdDesc(Integer var1, Pageable var2);

    @Query(value="SELECT COUNT(p) FROM OrderPo p WHERE p.status=?1")
    public Integer findCountByStatus(Integer var1);

    public List<OrderPo> findByBuyerIdOrderByIdDesc(Long var1, Pageable var2);

    @Query(value="SELECT COUNT(p) FROM OrderPo p WHERE p.buyerId=?1")
    public Integer findCountByBuyerId(Long var1);

    public List<OrderPo> findByDeliveryDepotIdOrderByIdDesc(String var1, Pageable var2);

    @Query(value="SELECT COUNT(p) FROM OrderPo p WHERE p.deliveryDepot.id=?1")
    public Integer findCountByDeliveryDepotId(String var1);

    public List<OrderPo> findByRefundStatusOrderByIdDesc(Integer var1, Pageable var2);

    @Query(value="SELECT COUNT(p) FROM OrderPo p WHERE p.refundStatus=?1")
    public Integer findCountByRefundStatus(Integer var1);

    public List<OrderPo> findByIdInOrderByIdDesc(Collection<Long> var1);

    public List<OrderPo> findByIdInOrderByFinishTimeDesc(Collection<Long> var1);

    public OrderPo findByNuomiId(Long var1);

    public List<OrderPo> findByNuomiIdInOrderByIdDesc(Collection<Long> var1);

    @Modifying
    @Query(value="update order_detail set paymentType=?2 where id= ?1", nativeQuery=true)
    public void updatePaymentType(Long var1, Integer var2);

    @Modifying
    @Query(value="update order_detail set appId=?2 where id= ?1", nativeQuery=true)
    public void updateAppId(Long var1, String var2);

    @Query(value="From OrderPo Where createTime between :startTime and :endTime and status >= :status and payStatus in (:payStatus) order by createTime")
    public List<OrderPo> findByStartTimeAndEndTimeAndOrderStatusGreatThanGivenStatusAndPayStatusIn(@Param(value="startTime") Timestamp var1, @Param(value="endTime") Timestamp var2, @Param(value="status") Integer var3, @Param(value="payStatus") List<Integer> var4);

    @Query(value="FROM OrderPo p WHERE p.status >= ?1 AND p.createTime >= ?2 AND p.createTime <= ?3")
    public List<OrderPo> getOrdersBy(Integer var1, Timestamp var2, Timestamp var3);

    @Query(value="FROM OrderPo p WHERE p.buyerId = ?1 AND p.createTime >= ?2 AND p.createTime < ?3 ORDER BY p.createTime")
    public List<OrderPo> findOrdersByBuyerIdAndStartTimeAndEndTime(Long var1, Timestamp var2, Timestamp var3);

    public OrderPo findByOrderCode(String var1);

    public boolean isFirstOrder(Long var1, Long var2);

    @Query(value="FROM OrderPo p WHERE p.status = ?1 AND p.createTime >= ?2 AND p.createTime < ?3 ORDER BY p.createTime")
    public List<OrderPo> findByStatusAndCreateTimeBetween(int var1, Timestamp var2, Timestamp var3);

    @Query(value="FROM OrderPo p WHERE p.status in ?1 AND p.createTime >= ?2 AND p.createTime < ?3 ORDER BY p.createTime")
    public List<OrderPo> findByStatusInAndCreateTimeBetween(Collection<Integer> var1, Timestamp var2, Timestamp var3);

    @Query(value="SELECT id FROM OrderPo p WHERE p.shopId = ?1 AND p.status >= 50")
    public List<Long> findSuccessOrderIdByShopId(Long var1);

    @Query(value="FROM OrderPo p WHERE p.status >= :status AND p.createTime >= :fromTime AND p.createTime < :toTime ORDER BY p.createTime desc")
    public List<OrderPo> findByStatusAndCreateTimeBetweenTwo(@Param(value="status") int var1, @Param(value="fromTime") Timestamp var2, @Param(value="toTime") Timestamp var3);

    @Query(value="FROM OrderPo p WHERE p.shopId = ?1 AND p.status >= 50")
    public List<OrderPo> findSuccessOrderByShopId(Long var1);

    public List<OrderPo> findOrderByShopId(Long var1);
}

