/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.mysql.order;

import com.depotnearby.common.dao.mysql.CommonManageAbleDao;
import com.depotnearby.common.exception.VersionChangedRuntimeException;
import com.depotnearby.common.model.order.IOrderQueryReqVo;
import com.depotnearby.common.po.order.OrderPo;
import com.depotnearby.common.vo.order.BackMoneyBillVo;
import com.depotnearby.common.vo.order.OrderItemVo;
import com.depotnearby.common.vo.order.OrderVo;
import com.depotnearby.dao.mysql.depot.DepotRepository;
import com.depotnearby.dao.mysql.order.OrderDao;
import com.depotnearby.dao.mysql.order.OrderRepository;
import com.depotnearby.dao.mysql.shop.ShopRepository;
import com.depotnearby.dao.mysql.user.UserRepository;
import com.depotnearby.util.DateTool;
import com.depotnearby.vo.statistic.DailyStatRecordResultVo;
import com.depotnearby.vo.statistic.DepotShopOrderStatisticResultVo;
import com.depotnearby.vo.statistic.InviteStatisticResultVo;
import com.depotnearby.vo.statistic.OrderPaymentStatisticResultVo;
import com.depotnearby.vo.statistic.OrderVoucherStatisticResultVo;
import com.depotnearby.vo.statistic.ProductSalesStatisticResultVo;
import com.depotnearby.vo.statistic.UserRecommendOrderedStatisticResultVo;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.codelogger.utils.ValueUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Repository;

@Repository(value="orderRepositoryImpl")
public class OrderRepositoryImpl
extends CommonManageAbleDao
implements OrderDao {
    @Autowired
    UserRepository userRepository;
    @Autowired
    ShopRepository shopRepository;
    @Autowired
    DepotRepository depotRepository;
    @Autowired
    OrderRepository orderRepository;

    public OrderPo findById(Long id) {
        return (OrderPo)this.orderRepository.findOne(id);
    }

    @Override
    public void updateOrderPayStatus(OrderPo order) throws VersionChangedRuntimeException {
        Query query = this.getEntityManager().createNativeQuery("update order_detail set payStatus = :payStatus ,version=:newVersion where id=:id and version=:version").setParameter("payStatus", (Object)order.getPayStatus()).setParameter("newVersion", (Object)(order.getVersion() + 1L)).setParameter("id", (Object)order.getId()).setParameter("version", (Object)order.getVersion());
        if (query.executeUpdate() != 1) {
            throw new VersionChangedRuntimeException();
        }
        order.incVersion();
    }

    @Override
    public void updateOrderStatus(OrderPo order) {
        Query query = this.getEntityManager().createNativeQuery("update order_detail set status = :status  where id=:id").setParameter("status", (Object)order.getStatus()).setParameter("id", (Object)order.getId());
        query.executeUpdate();
    }

    @Override
    public void updateForFinish(OrderPo order) throws VersionChangedRuntimeException {
        Query query = this.getEntityManager().createNativeQuery("update order_detail set status=:status,finishTime=:finishTime,version=:newVersion where id=:id and version=:version").setParameter("status", (Object)order.getStatus()).setParameter("finishTime", (Object)order.getFinishTime()).setParameter("newVersion", (Object)(order.getVersion() + 1L)).setParameter("id", (Object)order.getId()).setParameter("version", (Object)order.getVersion());
        if (query.executeUpdate() != 1) {
            throw new VersionChangedRuntimeException();
        }
        order.incVersion();
    }

    @Override
    public void updateForAcceptOrReject(OrderPo order) {
        Query query = this.getEntityManager().createNativeQuery("update order_detail set payStatus = :payStatus ,status = :status ,acceptTime=:acceptTime where id=:id").setParameter("payStatus", (Object)order.getPayStatus()).setParameter("status", (Object)order.getStatus()).setParameter("acceptTime", (Object)order.getAcceptTime()).setParameter("id", (Object)order.getId());
        query.executeUpdate();
    }

    @Override
    public Page<OrderPo> getOrdersLimitedBy(final int accept, final Set<Long> shopIds, final Timestamp startTime, final Timestamp endTime, Pageable pageable) {
        return this.orderRepository.findAll((Specification)new Specification<OrderPo>(){

            public Predicate toPredicate(Root<OrderPo> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                ArrayList<Object> predicates = new ArrayList<Object>();
                if (ValueUtils.getValue((Boolean)((long)accept != 0L ? 1 : 0)).booleanValue()) {
                    predicates.add(cb.greaterThanOrEqualTo(root.get("status").as(Integer.class), (Comparable)Integer.valueOf(accept)));
                }
                if (CollectionUtils.isNotEmpty((Collection)shopIds)) {
                    CriteriaBuilder.In in = cb.in((Expression)root.get("shopId"));
                    Iterator iterator = shopIds.iterator();
                    while (iterator.hasNext()) {
                        in.value(iterator.next());
                    }
                    predicates.add(in);
                }
                predicates.add(cb.greaterThanOrEqualTo(root.get("createTime").as(Timestamp.class), (Comparable)startTime));
                predicates.add(cb.lessThanOrEqualTo(root.get("createTime").as(Timestamp.class), (Comparable)endTime));
                if (predicates.size() > 0) {
                    return cb.and(predicates.toArray(new Predicate[predicates.size()]));
                }
                return null;
            }
        }, pageable);
    }

    @Override
    public Page<OrderPo> searchOrders(final IOrderQueryReqVo vo, Pageable pageable) {
        return this.orderRepository.findAll((Specification)new Specification<OrderPo>(){

            public Predicate toPredicate(Root<OrderPo> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                if ((long)ValueUtils.getValue((Integer)vo.getType()).intValue() != 0L && ValueUtils.getValue((Boolean)(vo.getChannelId() != null ? 1 : 0)).booleanValue()) {
                    predicates.add(cb.or((Expression)cb.equal((Expression)root.get("type"), (Object)vo.getType()), (Expression)cb.equal((Expression)root.get("channelId"), (Object)vo.getChannelId())));
                } else {
                    if ((long)ValueUtils.getValue((Integer)vo.getType()).intValue() != 0L) {
                        predicates.add(cb.equal((Expression)root.get("type"), (Object)vo.getType()));
                    }
                    if (ValueUtils.getValue((Boolean)(vo.getChannelId() != null ? 1 : 0)).booleanValue()) {
                        predicates.add(cb.equal((Expression)root.get("channelId"), (Object)vo.getChannelId()));
                    }
                }
                if (ValueUtils.getValue((Long)vo.getOrderId()) != 0L) {
                    predicates.add(cb.equal((Expression)root.get("id"), (Object)vo.getOrderId()));
                }
                if (ValueUtils.getValue((Long)vo.getNuomiId()) != 0L) {
                    predicates.add(cb.equal((Expression)root.get("nuomiId"), (Object)vo.getNuomiId()));
                }
                if (ValueUtils.getValue((Long)vo.getNuomiBuyerId()) != 0L) {
                    predicates.add(cb.equal((Expression)root.get("nuomiBuyerId"), (Object)vo.getNuomiBuyerId()));
                }
                if (ValueUtils.getValue((Integer)vo.getNuomiStatus()) != 0) {
                    predicates.add(cb.equal((Expression)root.get("nuomiStatus"), (Object)vo.getNuomiStatus()));
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getOrderCode())) {
                    predicates.add(cb.equal((Expression)root.get("orderCode"), (Object)vo.getOrderCode()));
                }
                if (ValueUtils.getValue((Integer)vo.getStatus()) != 0) {
                    predicates.add(cb.equal((Expression)root.get("status"), (Object)vo.getStatus()));
                    if (vo.getStatus() == 50) {
                        predicates.add(cb.equal((Expression)root.get("refundStatus"), (Object)0));
                    }
                }
                if (ValueUtils.getValue((Integer)vo.getRefundStatus()) != 0) {
                    predicates.add(cb.equal((Expression)root.get("refundStatus"), (Object)vo.getRefundStatus()));
                }
                if (ValueUtils.getValue((Long)vo.getUserId()) != 0L) {
                    predicates.add(cb.equal((Expression)root.get("buyerId"), (Object)vo.getUserId()));
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getDepotId())) {
                    predicates.add(cb.equal((Expression)root.get("deliveryDepot").get("id"), (Object)vo.getDepotId()));
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{vo.getFromTime()})) {
                    Timestamp fromTime = DateTool.getTimestamp((String)vo.getFromTime());
                    predicates.add(cb.greaterThanOrEqualTo(root.get("createTime").as(Timestamp.class), (Comparable)fromTime));
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{vo.getEndTime()})) {
                    Timestamp endTime = DateTool.getTimestamp((String)vo.getEndTime());
                    predicates.add(cb.lessThanOrEqualTo(root.get("createTime").as(Timestamp.class), (Comparable)endTime));
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getDepotId())) {
                    predicates.add(cb.equal((Expression)root.get("priceDepot").get("id"), (Object)vo.getDepotId()));
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getDeliveryDepotId())) {
                    predicates.add(cb.equal((Expression)root.get("deliveryDepot").get("id"), (Object)vo.getDeliveryDepotId()));
                }
                if (ValueUtils.getValue((Integer)vo.getDepotType()) != 0) {
                    predicates.add(cb.equal((Expression)root.get("priceDepot").get("depotType"), (Object)vo.getDepotType()));
                }
                if (ValueUtils.getValue((Long)vo.getCompanyId()) != 0L) {
                    predicates.add(cb.equal((Expression)root.get("priceDepot").get("company").get("id"), (Object)vo.getCompanyId()));
                }
                if (predicates.size() > 0) {
                    return cb.and(predicates.toArray(new Predicate[predicates.size()]));
                }
                return null;
            }
        }, pageable);
    }

    @Override
    public List<Number> findFirstOrderUserIdsBy(Set<Long> userIds, Integer status, Timestamp starttime) {
        Query query = this.getEntityManager().createNativeQuery("SELECT buyerid FROM (SELECT buyerid, MIN(createtime) AS createtime FROM order_detail AS mintime_result WHERE buyerid IN (:userIds) AND status >= :status GROUP BY buyerid) A WHERE createtime < :starttime");
        query.setParameter("userIds", userIds).setParameter("status", (Object)status).setParameter("starttime", (Object)starttime);
        return query.getResultList();
    }

    @Override
    public List<OrderPaymentStatisticResultVo> findSuccessOrderPaymentsBy(Timestamp startTime, Timestamp endTime, Integer paymentType) {
        Query query = this.getEntityManager().createNativeQuery("SELECT od.id AS id, op.paidtime AS paidtime, op.tradeno AS tradeno, od.createtime AS createtime,od.ordercode AS ordercode, op.payamount AS payamount, op.paymenttype AS paymenttype FROM order_payment op LEFT JOIN order_detail od ON od.id = op.orderid WHERE op.paidtime >= :startTime AND op.paidtime < :endTime AND op.paystatus >= :payStatus AND op.paymenttype = :paymentType", "OrderPaymentStatisticBinding");
        query.setParameter("startTime", (Object)startTime).setParameter("endTime", (Object)endTime).setParameter("payStatus", (Object)50).setParameter("paymentType", (Object)paymentType);
        return query.getResultList();
    }

    @Override
    public List<ProductSalesStatisticResultVo> findProductSaleInfoBy(Timestamp startTime, Timestamp endTime, Map<String, Object> searchParams) {
        StringBuilder sb = new StringBuilder();
        if (searchParams.get("centerId") != null && StringUtils.isNotBlank((CharSequence)searchParams.get("centerId").toString())) {
            sb.append(" AND pro.centerId = :centerId");
        }
        if (searchParams.get("productName") != null && StringUtils.isNotBlank((CharSequence)searchParams.get("productName").toString())) {
            sb.append(" AND pro.name LIKE :productName");
        }
        if (searchParams.get("productType") != null) {
            sb.append(" AND pro.categroyId IN (:productType)");
        }
        if (searchParams.get("shopType") != null) {
            sb.append(" AND sp.shopTypeId IN (:shopType)");
        }
        if (searchParams.get("province") != null) {
            sb.append(" AND gpo.id IN (:provinces)");
        }
        String sql = "SELECT gpo.name AS province_name,stp.name AS shop_type_name,pca.name AS product_category,pro.name AS product_name,SUM(oi.price * oi.quantity) / SUM(oi.quantity) AS avg_price,SUM(oi.quantity) AS total_quantity,SUM(oi.price * oi.quantity) AS total_amount FROM order_item oi LEFT JOIN order_detail od ON od.id = oi.orderId LEFT JOIN shop sp ON sp.id = od.shopId LEFT JOIN shop_type stp ON sp.shopTypeId = stp.id LEFT JOIN pro_product pro ON pro.id = oi.productId LEFT JOIN pro_category pca ON pca.id = pro.categroyId LEFT JOIN geo_province gpo ON gpo.id = sp.provinceId WHERE od.createtime >= :startTime AND od.createtime < :endTime%s AND od.status >= 50 GROUP BY province_name, shop_type_name, product_category, product_name ORDER BY province_name, total_quantity";
        Query query = this.getEntityManager().createNativeQuery(String.format(sql, sb.toString()), "ProductSalesStatisticBinding");
        query.setParameter("startTime", (Object)startTime).setParameter("endTime", (Object)endTime);
        if (searchParams.get("centerId") != null && StringUtils.isNotBlank((CharSequence)searchParams.get("centerId").toString())) {
            query.setParameter("centerId", searchParams.get("centerId"));
        }
        if (searchParams.get("productName") != null && StringUtils.isNotBlank((CharSequence)searchParams.get("productName").toString())) {
            query.setParameter("productName", searchParams.get("productName"));
        }
        if (searchParams.get("productType") != null) {
            query.setParameter("productType", searchParams.get("productType"));
        }
        if (searchParams.get("shopType") != null) {
            query.setParameter("shopType", searchParams.get("shopType"));
        }
        if (searchParams.get("province") != null) {
            query.setParameter("provinces", searchParams.get("province"));
        }
        return query.getResultList();
    }

    @Override
    public List<InviteStatisticResultVo> findInvitorStatisticBy(Timestamp startTime, Timestamp endTime, Map<String, Object> searchParams) {
        StringBuilder sb = new StringBuilder();
        if (searchParams.get("inviteName") != null && StringUtils.isNotBlank((CharSequence)searchParams.get("inviteName").toString())) {
            sb.append(" AND de.name LIKE :inviteName");
        }
        if (searchParams.get("shopTypes") != null && CollectionUtils.isNotEmpty((Collection)((Set)searchParams.get("shopTypes")))) {
            sb.append(" AND st.id IN (:shopTypes)");
        }
        String sql = "SELECT \n  de.name AS invite_name,\n  sp.inviterCode AS invite_code,\n  st.name AS shop_type_name,\n  COUNT(DISTINCT(sp.id)) AS shop_count,\n  SUM(od.orderamount) AS order_amount,\n  SUM(od.payamount) AS pay_amount,\n  SUM(od.voucheroffsetamount) AS offset_amount\nFROM order_detail od\nLEFT JOIN shop sp ON od.shopid = sp.id\nLEFT JOIN shop_type st ON sp.shopTypeId = st.id\nLEFT JOIN depot_employee de ON sp.invitercode = de.id\nWHERE sp.invitercode IS NOT NULL AND sp.invitercode != ''\nAND od.status >= '50'\nAND od.createtime >= :startTime\nAND od.createtime < :endTime\n %s GROUP BY sp.inviterCode, de.name, st.name\nORDER BY shop_count";
        Query query = this.getEntityManager().createNativeQuery(String.format(sql, sb.toString()), "InviterStatisticBinding");
        query.setParameter("startTime", (Object)startTime).setParameter("endTime", (Object)endTime);
        if (searchParams.get("inviteName") != null && StringUtils.isNotBlank((CharSequence)searchParams.get("inviteName").toString())) {
            query.setParameter("inviteName", searchParams.get("inviteName"));
        }
        if (searchParams.get("shopTypes") != null && CollectionUtils.isNotEmpty((Collection)((Set)searchParams.get("shopTypes")))) {
            query.setParameter("shopTypes", searchParams.get("shopTypes"));
        }
        return query.getResultList();
    }

    @Override
    public List<DepotShopOrderStatisticResultVo> findDepotShopOrderStatisticBy(Timestamp startTime, Timestamp endTime, Map<String, Object> searchParams) {
        StringBuilder sb = new StringBuilder();
        if (searchParams.get("provinceId") != null) {
            sb.append(" AND sp.provinceId = :provinceId");
        }
        if (searchParams.get("depotId") != null && StringUtils.isNotBlank((CharSequence)searchParams.get("depotId").toString())) {
            sb.append(" AND sp.assartDepotId = :depotId");
        }
        String sql = "SELECT gp.id AS province_id,\n    gp.name AS province_name,\n    dt.name AS depot_name,\n    COUNT(DISTINCT(od.shopid)) AS order_shop_count,\n    SUM(od.orderamount) AS order_amount,\n    SUM(od.payamount) AS pay_amount,\n    SUM(od.voucheroffsetamount) AS offset_amount\nFROM order_detail od\nLEFT JOIN shop sp ON sp.id = od.shopid\nLEFT JOIN geo_province gp ON gp.id = sp.provinceId\nLEFT JOIN depot dt ON sp.depotId = dt.id\nWHERE od.status >= '50'\nAND od.createtime >= :startTime\nAND od.createtime < :endTime\n %s GROUP BY province_id, province_name, depot_name\n";
        Query query = this.getEntityManager().createNativeQuery(String.format(sql, sb.toString()), "DepotShopOrderStatisticBinding");
        query.setParameter("startTime", (Object)startTime).setParameter("endTime", (Object)endTime);
        if (searchParams.get("provinceId") != null) {
            query.setParameter("provinceId", searchParams.get("provinceId"));
        }
        if (searchParams.get("depotId") != null && StringUtils.isNotBlank((CharSequence)searchParams.get("depotId").toString())) {
            query.setParameter("depotId", (Object)searchParams.get("depotId").toString());
        }
        return query.getResultList();
    }

    @Override
    public List<DailyStatRecordResultVo> getDailyStatRecordBy(Date day) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
        String startTime = sdf.format(DateUtils.truncate((Date)day, (int)5));
        String endTime = sdf.format(DateUtils.addMilliseconds((Date)DateUtils.ceiling((Date)day, (int)5), (int)-1));
        Query query = this.getEntityManager().createNativeQuery("SELECT \n    date_format(od.createtime, '%Y-%m-%d') AS d_day,\n    gp.id AS province_id,\n    st.id AS shop_type_id,\n    SUM(od.orderamount) AS order_amount,\n    COUNT(od.id) AS order_count\nFROM order_detail od\nLEFT JOIN shop sp ON sp.id = od.shopid\nLEFT JOIN shop_type st ON st.id = sp.shopTypeId\nLEFT JOIN geo_province gp ON gp.id = sp.provinceId\nWHERE od.status >= '50'\nAND od.createtime >= :startTime\nAND od.createtime <= :endTime\nGROUP BY d_day, province_id, shop_type_id", "DailyStatRecordBinding");
        query.setParameter("startTime", (Object)startTime).setParameter("endTime", (Object)endTime);
        return query.getResultList();
    }

    public boolean isFirstOrder(Long userId, Long orderId) {
        Query query = this.getEntityManager().createQuery("select count(*) from OrderPo p where p.buyerId=:buyerId and p.id!=:orderId and p.status=:status");
        query.setParameter("buyerId", (Object)userId);
        query.setParameter("orderId", (Object)orderId);
        query.setParameter("status", (Object)100);
        Number count = (Number)query.getSingleResult();
        return count.intValue() == 0;
    }

    @Override
    public List<OrderVoucherStatisticResultVo> findOrderVoucherStatistic(Map<String, Object> searchParams) {
        String sql = "SELECT\n    od.createtime AS time,\n    od.ordercode AS order_code,\n    ur.mobile AS user_mobile,\n    gp.name AS province_name,\n    st.name AS shop_type_name,\n    vt.name AS voucher_type_name,\n    od.orderamount AS order_amount,\n    od.voucheroffsetamount AS voucher_offset_amount,\n    od.payamount AS order_pay_amount\nFROM order_detail od \nLEFT JOIN order_voucher ov ON od.id = ov.orderId\nLEFT JOIN vou_type vt ON vt.id = ov.voucherTypeId\nLEFT JOIN usr_user ur ON od.buyerid = ur.id\nLEFT JOIN shop sp ON od.shopId = sp.id\nLEFT JOIN shop_type st ON sp.shopTypeId = st.id\nLEFT JOIN geo_province gp ON gp.id = sp.provinceId\nWHERE od.status >= '50'\nAND vt.name IS NOT NULL\n";
        StringBuilder sb = new StringBuilder();
        if (searchParams.get("orderCode") != null) {
            sb.append("AND od.ordercode = :orderCode");
        }
        if (searchParams.get("startTime") != null) {
            sb.append("AND od.createtime >= :startTime\n");
        }
        if (searchParams.get("endTime") != null) {
            sb.append("AND od.createtime <= :endTime\n");
        }
        if (searchParams.get("provinceId") != null) {
            sb.append("AND sp.provinceId = :provinceId\n");
        }
        if (searchParams.get("shopTypeId") != null) {
            sb.append("AND sp.shopTypeId = :shopTypeId\n");
        }
        if (searchParams.get("userMobile") != null) {
            sb.append("AND ur.mobile = :userMobile\n");
        }
        if (searchParams.get("voucherTypeName") != null) {
            sb.append("AND vt.name = :voucherTypeName\n");
        }
        if (searchParams.get("orderAmountMax") != null) {
            sb.append("AND od.orderamount <= :orderAmountMax\n");
        }
        if (searchParams.get("orderAmountMin") != null) {
            sb.append("AND od.orderamount >= :orderAmountMin\n");
        }
        if (searchParams.get("orderVoucherOffsetAmountMin") != null) {
            sb.append("AND voucheroffsetamount >= :orderVoucherOffsetAmountMin\n");
        }
        if (searchParams.get("orderVoucherOffsetAmountMax") != null) {
            sb.append("AND voucheroffsetamount <= :orderVoucherOffsetAmountMax\n");
        }
        if (searchParams.get("orderPayAmountMin") != null) {
            sb.append("AND od.payamount >= :orderPayAmountMin\n");
        }
        if (searchParams.get("orderPayAmountMax") != null) {
            sb.append("AND od.payamount <= :orderPayAmountMax\n");
        }
        Query query = this.getEntityManager().createNativeQuery(sql.concat(sb.toString()), "OrderVoucherRecordBinding");
        if (searchParams.get("orderCode") != null) {
            query.setParameter("orderCode", searchParams.get("orderCode"));
        }
        if (searchParams.get("startTime") != null) {
            query.setParameter("startTime", searchParams.get("startTime"));
        }
        if (searchParams.get("endTime") != null) {
            query.setParameter("endTime", searchParams.get("endTime"));
        }
        if (searchParams.get("provinceId") != null) {
            query.setParameter("provinceId", searchParams.get("provinceId"));
        }
        if (searchParams.get("shopTypeId") != null) {
            query.setParameter("shopTypeId", searchParams.get("shopTypeId"));
        }
        if (searchParams.get("userMobile") != null) {
            query.setParameter("userMobile", searchParams.get("userMobile"));
        }
        if (searchParams.get("voucherTypeName") != null) {
            query.setParameter("voucherTypeName", searchParams.get("voucherTypeName"));
        }
        if (searchParams.get("orderAmountMax") != null) {
            query.setParameter("orderAmountMax", searchParams.get("orderAmountMax"));
        }
        if (searchParams.get("orderAmountMin") != null) {
            query.setParameter("orderAmountMin", searchParams.get("orderAmountMin"));
        }
        if (searchParams.get("orderVoucherOffsetAmountMin") != null) {
            query.setParameter("orderVoucherOffsetAmountMin", searchParams.get("orderVoucherOffsetAmountMin"));
        }
        if (searchParams.get("orderVoucherOffsetAmountMax") != null) {
            query.setParameter("orderVoucherOffsetAmountMax", searchParams.get("orderVoucherOffsetAmountMax"));
        }
        if (searchParams.get("orderPayAmountMin") != null) {
            query.setParameter("orderPayAmountMin", searchParams.get("orderPayAmountMin"));
        }
        if (searchParams.get("orderPayAmountMax") != null) {
            query.setParameter("orderPayAmountMax", searchParams.get("orderPayAmountMax"));
        }
        return query.getResultList();
    }

    @Override
    public List<UserRecommendOrderedStatisticResultVo> findUserRecommendOrderedStatisticBy(Timestamp startTime, Timestamp endTime, Map<String, Object> searchParams) {
        StringBuilder sb = new StringBuilder();
        if (searchParams.get("productName") != null) {
            sb.append(" AND pro.name LIKE :productName");
        }
        if (searchParams.get("centerId") != null) {
            sb.append(" AND pro.centerId = :centerId");
        }
        if (searchParams.get("mobile") != null) {
            sb.append(" AND usr.mobile = :mobile");
        }
        if (searchParams.get("productCategoryId") != null) {
            sb.append(" AND pro.categroyId = :productCategoryId");
        }
        if (searchParams.get("shopTypeId") != null) {
            sb.append(" AND sp.shopTypeId = :shopTypeId");
        }
        String sql = "SELECT \n    usr.mobile AS mobile,\n    st.name AS shop_type_name,\n    pro.name AS product_name,\n    pc.name AS category_name,\n    SUM(oi.quantity) AS product_quantity,\n    SUM(oi.quantity * oi.price) AS total_amount,\n    SUM(oi.quantity * oi.price) / SUM(oi.quantity) AS avg_price\nFROM order_item oi\nLEFT JOIN order_detail od ON od.id = oi.orderId\nLEFT JOIN shop sp ON od.shopid = sp.id\nLEFT JOIN shop_type st ON st.id = sp.shopTypeId\nLEFT JOIN pro_product pro ON pro.id = oi.productid\nLEFT JOIN pro_category pc ON pro.categroyId = pc.id\nLEFT JOIN usr_user usr ON od.buyerid = usr.id\nWHERE od.source = '1'\nAND od.createtime >= :startTime AND od.createtime < :endTime\n%s\nGROUP BY mobile, shop_type_name, product_name, category_name";
        Query query = this.getEntityManager().createNativeQuery(String.format(sql, sb.toString()), "UserRecommendOrderedStatisticBinding");
        query.setParameter("startTime", (Object)startTime).setParameter("endTime", (Object)endTime);
        if (searchParams.get("productName") != null) {
            query.setParameter("productName", searchParams.get("productName"));
        }
        if (searchParams.get("centerId") != null) {
            query.setParameter("centerId", searchParams.get("centerId"));
        }
        if (searchParams.get("mobile") != null) {
            query.setParameter("mobile", searchParams.get("mobile"));
        }
        if (searchParams.get("productCategoryId") != null) {
            query.setParameter("productCategoryId", searchParams.get("productCategoryId"));
        }
        if (searchParams.get("shopTypeId") != null) {
            query.setParameter("shopTypeId", searchParams.get("shopTypeId"));
        }
        return query.getResultList();
    }

    @Override
    public Integer getSalesVolumeByProductIdAndDateBetweenAndStatusIn(Long productId, Timestamp startTime, Timestamp endTime, List<Integer> statusList) {
        String sql = "select sum(oi.quantity) from order_detail od left join order_payment op on od.id = op.orderId left join order_item oi on od.id = oi.orderId where od.createTime between :startTime and :endTime and od.status in (:status) and  oi.productid = :productId";
        Query query = this.getEntityManager().createNativeQuery(sql);
        query.setParameter("productId", (Object)productId);
        query.setParameter("startTime", (Object)startTime);
        query.setParameter("endTime", (Object)endTime);
        query.setParameter("status", statusList);
        Object result = query.getSingleResult();
        return result == null ? 0 : Integer.valueOf(result.toString());
    }

    @Override
    public Integer getSalesVolumeByProductIdAndSalePriceEqualAndDateBetweenAndStatusIn(Long productId, Integer salePrice, Timestamp startTime, Timestamp endTime, List<Integer> statusList) {
        String sql = "select sum(oi.quantity) from order_detail od left join order_payment op on od.id = op.orderId left join order_item oi on od.id = oi.orderId and oi.price = :salePrice where od.createTime between :startTime and :endTime and od.status in (:status) and  oi.productid = :productId";
        Query query = this.getEntityManager().createNativeQuery(sql);
        query.setParameter("productId", (Object)productId);
        query.setParameter("salePrice", (Object)salePrice);
        query.setParameter("startTime", (Object)startTime);
        query.setParameter("endTime", (Object)endTime);
        query.setParameter("status", statusList);
        Object result = query.getSingleResult();
        return result == null ? 0 : Integer.valueOf(result.toString());
    }

    @Override
    public Integer getProductCountByUserIdAndProductIdAndDateBetweenAndStatusIn(Long buyerId, Long productId, Timestamp startTime, Timestamp endTime, List<Integer> statusList) {
        String sql = "select sum(oi.quantity) from order_detail od left join order_payment op on od.id = op.orderId left join order_item oi on od.id = oi.orderId where od.buyerId = :buyerId and od.createTime between :startTime and :endTime and od.status in (:status) and  oi.productid = :productId";
        Query query = this.getEntityManager().createNativeQuery(sql);
        query.setParameter("buyerId", (Object)buyerId);
        query.setParameter("productId", (Object)productId);
        query.setParameter("startTime", (Object)startTime);
        query.setParameter("endTime", (Object)endTime);
        query.setParameter("status", statusList);
        Object result = query.getSingleResult();
        return result == null ? 0 : Integer.valueOf(result.toString());
    }

    @Override
    public OrderVo getOrderVo(Long orderId) {
        String sql = "SELECT o.id id, o.ordercode orderCode, o.payamount payAmount  from order_detail o where o.id =:orderId ";
        Query query = this.getEntityManager().createNativeQuery(sql, "OrderVo").setParameter("orderId", (Object)orderId);
        return (OrderVo)query.getSingleResult();
    }

    @Override
    public List<OrderItemVo> getOrderItemVos(Long orderId) {
        String sql = "SELECT oi.productlogo productlogo ,oi.name name ,oi.quantity quantity from order_item oi  where oi.orderid =:orderId ";
        Query query = this.getEntityManager().createNativeQuery(sql, "OrderItemVo").setParameter("orderId", (Object)orderId);
        return query.getResultList();
    }

    @Override
    public List<BackMoneyBillVo> findAllBackMoneyList(BackMoneyBillVo vo) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select a.id as orderId, b.id as refundId,a.ordercode as orderCode, ");
        sql.append(" b.type as refundType, b.reason as refundReason, ");
        sql.append(" date_format(b.createtime,'%Y-%m-%d %H:%i:%S') AS refundApplyTime,");
        sql.append(" b.operator as refundOperator,");
        sql.append(" date_format(b.operatetime,'%Y-%m-%d %H:%i:%S') AS refundOperateTime,");
        sql.append(" b.orderrefundamt as backAmt, b.backamtstatus as backAmtStatus");
        sql.append(" from order_detail a, order_apply_refund b");
        sql.append(" where a.id = b.orderid and b.orderrefundstatus = 0 and b.`status` = 0");
        if (StringUtils.isNotEmpty((CharSequence)vo.getOrderCode())) {
            sql.append(" and a.ordercode = :orderCode");
        }
        if (null != vo.getRefundType() && vo.getRefundType() != 0) {
            sql.append(" and b.type = :type");
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getStartTime())) {
            sql.append(" and date_format(b.createtime,'%Y-%m-%d') >= :startTime");
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getEndTime())) {
            sql.append(" and date_format(b.createtime,'%Y-%m-%d') <= :endTime");
        }
        Query query = this.getEntityManager().createNativeQuery(sql.toString(), "BackMoneyVo");
        if (StringUtils.isNotEmpty((CharSequence)vo.getOrderCode())) {
            query.setParameter("orderCode", (Object)vo.getOrderCode());
        }
        if (null != vo.getRefundType() && vo.getRefundType() != 0) {
            query.setParameter("type", (Object)vo.getRefundType());
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getStartTime())) {
            query.setParameter("startTime", (Object)vo.getStartTime());
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getEndTime())) {
            query.setParameter("endTime", (Object)vo.getEndTime());
        }
        return query.getResultList();
    }
}

