/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.mysql.product;

import com.depotnearby.common.dao.mysql.CommonManageAbleDao;
import com.depotnearby.common.vo.brand.BrandVo;
import com.depotnearby.dao.mysql.product.BrandDao;
import java.math.BigInteger;
import java.util.List;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;

public class BrandRepositoryImpl
extends CommonManageAbleDao
implements BrandDao {
    @Override
    public int findBrandByNameOrEn(String name, String nameEn, Integer brandId) {
        StringBuffer sb = new StringBuffer();
        if (StringUtils.isNotBlank((CharSequence)nameEn)) {
            sb.append("and nameEn = :nameEn");
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            sb.append("and name = :name");
        }
        String sql = "select count(1) from pro_brand where 1 = 1 and status != 0 and id != :id  %s ";
        Query query = this.getEntityManager().createNativeQuery(String.format(sql, sb)).setParameter("id", (Object)brandId);
        if (StringUtils.isNotBlank((CharSequence)nameEn)) {
            query.setParameter("nameEn", (Object)nameEn);
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            query.setParameter("name", (Object)name);
        }
        List number = query.getResultList();
        return ((BigInteger)number.get(0)).intValue();
    }

    @Override
    public List<BrandVo> findByBusinessIdAndCategoryId(Integer bid, Integer cid) {
        StringBuilder str = new StringBuilder();
        str.append("select  DISTINCT pb.id as id,pb.name as name,ifnull(pb.logo,'') as logo from pro_brand pb  inner join pro_product p").append(" on p.brandId=pb.id where p.categroyId=:cid and p.productBusinessId=:bid");
        Query query = this.getEntityManager().createNativeQuery(str.toString(), "BrandVo").setParameter("cid", (Object)cid).setParameter("bid", (Object)bid);
        return query.getResultList();
    }

    @Override
    public List<BrandVo> findBrandInfoByCategoryId(Integer categoryId) {
        StringBuilder str = new StringBuilder();
        str.append("select  DISTINCT pb.id as id,pb.name as name,ifnull(pb.logo,'') as logo from pro_brand pb where pb.categoryId=:categoryId and pb.status = 1");
        Query query = this.getEntityManager().createNativeQuery(str.toString(), "BrandVo").setParameter("categoryId", (Object)categoryId);
        return query.getResultList();
    }
}

