/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.mysql.product;

import com.depotnearby.common.po.depot.DepotType;
import com.depotnearby.common.po.product.DepotProductPo;
import com.depotnearby.dao.mysql.product.DepotProductDao;
import java.util.Collection;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface DepotProductRepository
extends JpaRepository<DepotProductPo, Long>,
DepotProductDao {
    public DepotProductPo findByDepotIdAndProductId(String var1, Long var2);

    public Long countByDepotId(String var1);

    @Query(value="FROM DepotProductPo d WHERE d.depot.id = :depotId ORDER BY d.percentageTag DESC")
    public List<DepotProductPo> findByDepotId(@Param(value="depotId") String var1);

    @Query(value="FROM DepotProductPo d WHERE d.product.id = :productId ORDER BY d.percentageTag DESC")
    public List<DepotProductPo> findByProductId(@Param(value="productId") Long var1);

    @Query(value="FROM DepotProductPo d WHERE d.product.id = :productId AND d.depot.depotType = :depotType ORDER BY d.percentageTag DESC")
    public List<DepotProductPo> findByProductIdAndDepotType(@Param(value="productId") Long var1, @Param(value="depotType") DepotType var2);

    public List<DepotProductPo> findByDepotIdAndProductIdIn(String var1, List<Long> var2);

    @Query(value="SELECT MAX(d.depotPrice) FROM DepotProductPo d WHERE d.product.id = ?1 AND d.status = 10 AND d.depotPrice != 19190000")
    public Integer findMaxDepotPrice(Long var1);

    @Modifying
    @Query(value="UPDATE DepotProductPo SET status = :status WHERE id = :id")
    public void updateStatus(@Param(value="id") Long var1, @Param(value="status") Integer var2);

    @Query(value="FROM DepotProductPo d JOIN FETCH d.product WHERE d.depot.id = ?1")
    public List<DepotProductPo> findByDepotIdquery(String var1);

    @Query(value="FROM DepotProductPo d WHERE d.depot.id IN :depotIds ORDER BY d.depot.id ASC")
    public List<DepotProductPo> findByDepotIdsAndLazyLoadProduct(@Param(value="depotIds") Collection<String> var1);

    @Query(value="SELECT dp FROM DepotProductPo dp LEFT JOIN dp.depot d WHERE dp.product.id = :productId AND d.depotType = :depotType AND d.city.id IN :cityIds")
    public List<DepotProductPo> findByProductIdAndDepotTypeAndCityIds(@Param(value="productId") Long var1, @Param(value="depotType") DepotType var2, @Param(value="cityIds") Collection<Integer> var3);

    public DepotProductPo findByDepotMcuCodeAndProductCenterId(String var1, String var2);

    @Query(value="select dp from DepotProductPo dp where dp.depot.id = :depotId order by dp.lastUpdateTime desc ")
    public List<DepotProductPo> findByDepot(@Param(value="depotId") String var1);

    @Query(value="select dp from DepotProductPo dp left join dp.depot d where d.depotType =:depotType")
    public List<DepotProductPo> findByDepotType(@Param(value="depotType") DepotType var1);

    @Query(value="select dp from DepotProductPo dp left join dp.depot d where d.depotType =:depotType and d.id = :depotId order by dp.lastUpdateTime desc")
    public List<DepotProductPo> findByDepotAndDepotType(@Param(value="depotId") String var1, @Param(value="depotType") DepotType var2);

    @Modifying
    @Query(value="UPDATE DepotProductPo SET companyStatus = :companyStatus WHERE id = :id")
    public void updateCompanyStatus(@Param(value="id") Long var1, @Param(value="companyStatus") Integer var2);

    @Query(value="SELECT dpp.id FROM DepotProductPo dpp WHERE dpp.product.id = :productId AND dpp.depot.company.id = :companyId")
    public List<Long> findDepotProductIdsByCompanyIdAndProductId(@Param(value="companyId") Long var1, @Param(value="productId") Long var2);

    @Query(value="FROM DepotProductPo d WHERE d.depot.company.id = :companyId")
    public List<DepotProductPo> findByCompanyId(@Param(value="companyId") Long var1);

    @Query(value="FROM DepotProductPo d WHERE d.product.id = :productId AND d.depot.company.id = :companyId")
    public List<DepotProductPo> findByCompanyIdAndProductId(@Param(value="companyId") Long var1, @Param(value="productId") Long var2);

    @Query(value="SELECT COUNT(d) FROM DepotProductPo d WHERE d.product.id = :productId AND d.depot.company.id = :companyId AND d.companyStatus = :companyStatus")
    public Integer countCompanyIdAndProductIdAndCompanyStatus(@Param(value="companyId") Long var1, @Param(value="productId") Long var2, @Param(value="companyStatus") Integer var3);

    @Query(value="SELECT d.depot.id, d.product.id, d.status FROM DepotProductPo d")
    public List<Object[]> findDepotIdAndProductIdAndStatus();

    @Query(value="SELECT d.id, d.product.id, d.depot.id, d.salePrice FROM DepotProductPo d where d.status = 10")
    public List<Object[]> findIdAndProductIdAndDepotIdAndSalePrice();

    @Query(value="FROM DepotProductPo d WHERE d.salePrice = :price OR d.depotPrice = :price OR d.costPrice = :price")
    public List<DepotProductPo> findBySalePriceOrDepotPriceOrCostPrice(@Param(value="price") int var1);
}

