/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.mysql.product;

import com.depotnearby.common.dao.mysql.CommonManageAbleDao;
import com.depotnearby.common.po.product.DepotProductPo;
import com.depotnearby.common.vo.depot.DepotCompanyStatusVo;
import com.depotnearby.dao.mysql.product.DepotProductDao;
import java.math.BigInteger;
import java.util.List;
import javax.persistence.Query;

public class DepotProductRepositoryImpl
extends CommonManageAbleDao
implements DepotProductDao {
    @Override
    public List<DepotProductPo> findForBuildIndex(int firstResult, int pageSize) {
        Query queryResult = this.getEntityManager().createQuery("FROM DepotProductPo p join fetch p.product");
        return queryResult.setFirstResult(firstResult).setMaxResults(pageSize).getResultList();
    }

    @Override
    public int updateCompanyStatusByCompanyIdAndProductId(Long companyId, Long productId, Integer companyStatus) {
        StringBuilder str = new StringBuilder();
        str.append("update pro_product_depot set companyStatus = :companyStatus where product_id = :productId ").append("and depot_id in (select id from depot where cityId ").append("in (select city_id from org_company_city where company_id = :companyId )) ");
        Query query = this.getEntityManager().createNativeQuery(str.toString()).setParameter("companyStatus", (Object)companyStatus).setParameter("productId", (Object)productId).setParameter("companyId", (Object)companyId);
        return query.executeUpdate();
    }

    @Override
    public List<DepotCompanyStatusVo> getDepotCompanyStatusByCompanyIdAndProductId(Long companyId, Long productId) {
        StringBuilder str = new StringBuilder();
        str.append("select pd.depot_id depotId, pd.id productDepotId, de.depotName, de.depotType, de.depotCity, pd.companystatus, pd.realQuantity, pd.salePrice, de.mcuCode  ").append(" from pro_product_depot pd left join ").append(" (select c.name depotCity, d.id, d.name depotName, d.depotType, d.mcuCode from depot d, geo_city c where d.cityid = c.id ) de on pd.depot_id=de.id ").append(" where pd.product_id = :productId and pd.depot_id in ( ").append(" select id from depot where cityId  ").append(" in (select city_id from org_company_city where company_id = :companyId)) ");
        Query query = this.getEntityManager().createNativeQuery(str.toString(), "DepotProductPoBinding").setParameter("productId", (Object)productId).setParameter("companyId", (Object)companyId);
        return query.getResultList();
    }

    @Override
    public Integer getSalePriceByDepotAndProductId(String depotId, Long productId) {
        StringBuilder str = new StringBuilder();
        str.append("select max(de.saleprice) from pro_product_depot de where product_id = :productId ").append(" and de.depot_id in (select d.id from depot d where d.cityId in ").append("   (select cityId from depot where id= :depotId)) ").append(" order by de.saleprice desc ");
        Query query = this.getEntityManager().createNativeQuery(str.toString()).setParameter("productId", (Object)productId).setParameter("depotId", (Object)depotId);
        List price = query.getResultList();
        return (Integer)price.get(0);
    }

    @Override
    public Integer getProductNumberByCompanyId(Long companyId, Long productId) {
        StringBuilder str = new StringBuilder();
        str.append("select count(1) from pro_product_depot pd where pd.depot_id ").append("in (select id from depot where cityId in (select city_id from org_company_city ").append("                                     where company_id = :companyId) and depottype=1) ").append("  and product_id = :productId");
        Query query = this.getEntityManager().createNativeQuery(str.toString()).setParameter("companyId", (Object)companyId).setParameter("productId", (Object)productId);
        List num = query.getResultList();
        return ((BigInteger)num.get(0)).intValue();
    }

    @Override
    public int updateCompanyStatusByCompanyIdAndProductId(Long companyId, List<Long> productId, Integer companyStatus) {
        StringBuilder str = new StringBuilder();
        str.append("update pro_product_depot set companyStatus = :companyStatus where product_id in( :productId) ").append("and depot_id in (select id from depot where cityId ").append("in (select city_id from org_company_city where company_id = :companyId )) ");
        Query query = this.getEntityManager().createNativeQuery(str.toString()).setParameter("companyStatus", (Object)companyStatus).setParameter("productId", productId).setParameter("companyId", (Object)companyId);
        return query.executeUpdate();
    }
}

