/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.mysql.product;

import com.depotnearby.common.dao.mysql.CommonManageAbleDao;
import com.depotnearby.dao.mysql.product.ProductCompanyDao;
import java.math.BigInteger;
import java.util.List;
import javax.persistence.Query;

public class ProductCompanyRepositoryImpl
extends CommonManageAbleDao
implements ProductCompanyDao {
    @Override
    public Integer getSalePriceByCompanyIdAndProductId(Long companyId, Long productId) {
        StringBuilder str = new StringBuilder();
        str.append("select max(de.saleprice) from pro_product_depot de where product_id = :productId ").append(" and de.depot_id in (select d.id from depot d where d.cityId in ").append("  (select city_id from org_company_city where company_id = :companyId)) ").append(" order by de.saleprice desc ");
        Query query = this.getEntityManager().createNativeQuery(str.toString()).setParameter("productId", (Object)productId).setParameter("companyId", (Object)companyId);
        List price = query.getResultList();
        return (Integer)price.get(0);
    }

    @Override
    public int getProductCompanyByCompanyIdAndProductId(Long companyId, Long productId) {
        StringBuilder str = new StringBuilder();
        str.append("select count(1) from pro_product_company where companyId = :companyId and productId = :productId");
        Query query = this.getEntityManager().createNativeQuery(str.toString()).setParameter("productId", (Object)productId).setParameter("companyId", (Object)companyId);
        List number = query.getResultList();
        return ((BigInteger)number.get(0)).intValue();
    }

    @Override
    public Integer getByProductIdAndDepotId(Long productId, String depotId) {
        StringBuilder str = new StringBuilder();
        str.append("select pc.warehouseprice from pro_product_company pc where pc.warehouseprice is not null ").append("and pc.warehouseprice > 0 and pc.productId = :productId and ").append("pc.companyId = (select cc.company_id from  org_company_city cc ").append(" left join depot d on d.cityid = cc.city_id where d.id= :depotId) ");
        Query query = this.getEntityManager().createNativeQuery(str.toString()).setParameter("productId", (Object)productId).setParameter("depotId", (Object)depotId);
        List list = query.getResultList();
        if (list.size() > 0) {
            return (Integer)list.get(0);
        }
        return null;
    }

    @Override
    public List<String> getDepotIdsByCompanyId(Long companyId) {
        StringBuilder str = new StringBuilder();
        str.append("select id from depot where auditstatus = 30 and (depottype=1 or depottype=2) ").append(" and cityid in (select city_id from org_company_city where company_id = :companyId) ");
        Query query = this.getEntityManager().createNativeQuery(str.toString()).setParameter("companyId", (Object)companyId);
        return query.getResultList();
    }
}

