/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.mysql.product;

import com.depotnearby.common.po.product.ProductPo;
import com.depotnearby.dao.mysql.product.ProductDao;
import java.util.List;
import javax.transaction.Transactional;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ProductRepository
extends JpaRepository<ProductPo, Long>,
ProductDao,
JpaSpecificationExecutor<ProductPo> {
    @Modifying
    @Transactional
    @Query(value="update ProductPo p set p.salesVolume = p.salesVolume + :quantity where p.id = :id")
    public void incProductSalesVolume(@Param(value="id") Long var1, @Param(value="quantity") int var2);

    @Query(value="select p.showQuantity from ProductPo p where p.id = :id")
    public Integer getShowQuantityByProductId(@Param(value="id") Long var1);

    @Modifying
    @Transactional
    @Query(value="update ProductPo p set p.showQuantity = p.showQuantity + :quantity where p.id = :id")
    public void incProductShowQuantity(@Param(value="id") Long var1, @Param(value="quantity") int var2);

    @Modifying
    @Transactional
    @Query(value="update ProductPo p set p.showQuantity = p.showQuantity - :quantity where p.id = :id")
    public void reduceProductShowQuantity(@Param(value="id") Long var1, @Param(value="quantity") int var2);

    @Query(value="select p.virtualQuantity from ProductPo p where p.id = :id")
    public Integer getVirtualQuantityByProductId(@Param(value="id") Long var1);

    @Modifying
    @Transactional
    @Query(value="update ProductPo p set p.virtualQuantity = p.virtualQuantity + :quantity where p.id = :id")
    public void incProductVirtualQuantity(@Param(value="id") Long var1, @Param(value="quantity") int var2);

    @Modifying
    @Transactional
    @Query(value="update ProductPo p set p.virtualQuantity = p.virtualQuantity - :quantity where p.id = :id")
    public void reduceProductVirtualQuantity(@Param(value="id") Long var1, @Param(value="quantity") int var2);

    @Modifying
    @Transactional
    @Query(value="update ProductPo p set p.pageView = p.pageView + :pageView where p.id = :id")
    public void incPageView(@Param(value="id") Long var1, @Param(value="pageView") int var2);

    @Query(value="FROM ProductPo p WHERE p.centerId = :centerId")
    public ProductPo findByCenterId(@Param(value="centerId") String var1);

    public List<ProductPo> findByStatus(Integer var1);

    @Query(value="SELECT p.id FROM ProductPo p WHERE p.status = :status")
    public List<Long> findProductIdsByStatus(@Param(value="status") Integer var1);

    @Query(value="FROM ProductPo p WHERE p.name like %:keyword%")
    public List<ProductPo> findByNameLike(@Param(value="keyword") String var1);

    @Query(value="FROM ProductPo p WHERE p.status = :status")
    public List<ProductPo> findProductByStatus(@Param(value="status") Integer var1);

    @Query(value="SELECT count(id) > 0 FROM ProductPo WHERE centerId = :centerId AND id != :productId")
    public Boolean isCenterIdExist(@Param(value="centerId") String var1, @Param(value="productId") Long var2);

    @Query(value="select new ProductPo(p.id,p.name,p.centerId) from ProductPo p where p.status=:str1 or p.status=:str2")
    public List<ProductPo> findProductIdsAndName(@Param(value="str1") Integer var1, @Param(value="str2") Integer var2);

    @Query(value="select new ProductPo(p.id,p.name,p.centerId) from ProductPo p")
    public List<ProductPo> findAllProduct();

    @Query(value="SELECT count(id) FROM ProductPo WHERE centerId = :centerId AND id != :productId")
    public Integer isCenterIdExistAndId(@Param(value="centerId") String var1, @Param(value="productId") Long var2);

    @Query(value="SELECT count(id) FROM ProductPo WHERE centerId = :centerId")
    public Integer isCenterIdET(@Param(value="centerId") String var1);

    public List<ProductPo> findByCategoryCode(String var1, Sort var2);

    @Query(value="SELECT DISTINCT p.brandName FROM ProductPo p where p.brandName is not null")
    public List<String> findProductBrands();

    @Query(value="SELECT DISTINCT p.seriesName FROM ProductPo p where p.seriesName is not null")
    public List<String> findProductSeriesName();

    @Query(value="SELECT DISTINCT p.bigCategoryName FROM ProductPo p where p.bigCategoryName is not null")
    public List<String> findProductBigCategoryName();

    @Query(value="SELECT DISTINCT p.smallCategoryName FROM ProductPo p where p.smallCategoryName is not null")
    public List<String> findProductSmallCategoryName();
}

