/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.mysql.product;

import com.depotnearby.common.dao.mysql.CommonManageAbleDao;
import com.depotnearby.common.po.product.ProductPo;
import com.depotnearby.common.vo.product.ProductExportVo;
import com.depotnearby.dao.mysql.product.ProductDao;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Query;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.transaction.annotation.Transactional;

public class ProductRepositoryImpl
extends CommonManageAbleDao
implements ProductDao {
    @Override
    public List<ProductPo> findForBuildIndex(int firstResult, int pageSize) {
        Query queryResult = this.getEntityManager().createQuery("from ProductPo p ");
        return queryResult.setFirstResult(firstResult).setMaxResults(pageSize).getResultList();
    }

    @Override
    public List<ProductPo> findCompanyProductBy(String depotId) {
        StringBuilder str = new StringBuilder();
        str.append("select p.* from pro_product p where p.id in ").append(" (select productId from pro_product_company pc where ").append(" pc.companyId = (select cc.company_id from  org_company_city cc ").append("  left join depot d on d.cityid = cc.city_id where d.depottype=2 and d.id=:depotId)) ");
        Query query = this.getEntityManager().createNativeQuery(str.toString()).setParameter("depotId", (Object)depotId);
        return query.getResultList();
    }

    @Override
    public List<Long> findProductIdByDepotId(String depotId) {
        StringBuilder str = new StringBuilder();
        str.append(" select productId from pro_product_company pc where ").append(" pc.commonStatus = 1 and pc.status = 10 and pc.companyId = (select cc.company_id from  org_company_city cc ").append("  left join depot d on d.cityid = cc.city_id where d.depottype=2 and d.id=:depotId) ");
        Query query = this.getEntityManager().createNativeQuery(str.toString()).setParameter("depotId", (Object)depotId);
        List number = query.getResultList();
        ArrayList<Long> longList = new ArrayList<Long>();
        for (BigInteger bigInteger : number) {
            longList.add(bigInteger.longValue());
        }
        return longList;
    }

    @Override
    public List<ProductExportVo> findProductExportVo() {
        StringBuilder sb = new StringBuilder();
        String sql = "select pp.centerid as centerid, pp.name as name, pp.origin as origin,\ncase pp.status when 0 then '\u4e0b\u67b6' when 10 then '\u4e0a\u67b6' else '\u5176\u5b83' end as status from pro_product pp;";
        Query query = this.getEntityManager().createNativeQuery(String.format(sql, sb.toString()), "ProductExportVo");
        return query.getResultList();
    }

    @Override
    @Modifying
    @Transactional
    public int updateProductPo(ProductPo obj) {
        return this.getEntityManager().createNativeQuery("update pro_product set  bigcategorycode=?,bigcategoryname=?,brandcode=?,brandname=?,categorycode=?,categoryname=?, channelcode=?,channelname=?, smallCategoryCode=?, smallCategoryName=?,seriescode=?,seriesname=?, specification=?, degrees=?, netVuloume=?, netUnit=? where id=?").setParameter(1, (Object)obj.getBigCategoryCode()).setParameter(2, (Object)obj.getBigCategoryName()).setParameter(3, (Object)obj.getBrandCode()).setParameter(4, (Object)obj.getBrandName()).setParameter(5, (Object)obj.getCategoryCode()).setParameter(6, (Object)obj.getCategoryName()).setParameter(7, (Object)obj.getChannelCode()).setParameter(8, (Object)obj.getChannelName()).setParameter(9, (Object)obj.getSmallCategoryCode()).setParameter(10, (Object)obj.getSmallCategoryName()).setParameter(11, (Object)obj.getSeriesCode()).setParameter(12, (Object)obj.getSeriesName()).setParameter(13, (Object)obj.getSpecification()).setParameter(14, (Object)obj.getDegrees()).setParameter(15, (Object)obj.getNetVuloume()).setParameter(16, (Object)obj.getNetUnit()).setParameter(17, (Object)obj.getId()).executeUpdate();
    }
}

