/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.mysql.product;

import com.depotnearby.common.dao.mysql.CommonManageAbleDao;
import com.depotnearby.common.vo.product.SaleAreaCityVo;
import com.depotnearby.dao.mysql.product.SaleAreaDao;
import java.math.BigInteger;
import java.util.List;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;

public class SaleAreaRepositoryImpl
extends CommonManageAbleDao
implements SaleAreaDao {
    @Override
    public int findSaleAreaByNameOrCode(String name, String code, Long areaId) {
        StringBuffer sb = new StringBuffer();
        if (StringUtils.isNotBlank((CharSequence)code)) {
            sb.append("and code = :code");
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            sb.append("and name = :name");
        }
        String sql = "select count(1) from pro_salearea where 1 = 1 and id != :id  %s ";
        Query query = this.getEntityManager().createNativeQuery(String.format(sql, sb)).setParameter("id", (Object)areaId);
        if (StringUtils.isNotBlank((CharSequence)code)) {
            query.setParameter("code", (Object)code);
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            query.setParameter("name", (Object)name);
        }
        List number = query.getResultList();
        return ((BigInteger)number.get(0)).intValue();
    }

    @Override
    public List<SaleAreaCityVo> getSaleAreaCityList(Integer areaId) {
        StringBuilder str = new StringBuilder();
        str.append("select sale_city.id id, sale_city.area_id saleAreaId,city.id cityId, city.baiduname cityName, province.baiduname provinceName");
        str.append(" FROM pro_salearea_city sale_city, geo_city city, geo_province province");
        str.append(" where sale_city.city_id = city.id AND city.provinceId = province.id AND sale_city.area_id = :areaId");
        str.append(" and sale_city.status = 1 ");
        Query query = this.getEntityManager().createNativeQuery(str.toString(), "SaleAreaCityVo").setParameter("areaId", (Object)areaId);
        return query.getResultList();
    }

    @Override
    public List<SaleAreaCityVo> getNotSelectCityList(Integer provinceId) {
        StringBuilder str = new StringBuilder();
        str.append("SELECT city.id cityId, city.baiduname cityName, province.baiduname provinceName");
        str.append(" FROM geo_province province, geo_city city");
        str.append(" where province.id = city.provinceId");
        str.append(" and not EXISTS (select 1 from pro_salearea_city where city.id = city_id and `status` = 1 )");
        str.append(" and province.id = :provinceId");
        Query query = this.getEntityManager().createNativeQuery(str.toString(), "SaleAreaCityVo2").setParameter("provinceId", (Object)provinceId);
        return query.getResultList();
    }
}

