/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.mysql.shop;

import com.depotnearby.common.dao.mysql.CommonRepository;
import com.depotnearby.common.po.shop.ShopPo;
import com.depotnearby.dao.mysql.shop.ShopDao;
import java.sql.Timestamp;
import java.util.List;
import java.util.Set;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ShopRepository
extends CommonRepository<ShopPo, Long>,
ShopDao {
    public List<ShopPo> findByMobileOrderByIdDesc(String var1);

    public ShopPo findByName(String var1);

    @Modifying
    @Query(value="update ShopPo set detailAuditStatus = :detailAuditStatus WHERE id = :id")
    public void updateDetailAuditStatus(@Param(value="id") Long var1, @Param(value="detailAuditStatus") Integer var2);

    @Modifying
    @Query(value="update ShopPo set qualificationAuditStatus = :qualificationAuditStatus WHERE id = :id")
    public void updateQualificationAuditStatus(@Param(value="id") Long var1, @Param(value="qualificationAuditStatus") Integer var2);

    @Modifying
    @Query(value="Update ShopPo Set status=:status where id=:id")
    public void updateShopStatusById(@Param(value="id") Long var1, @Param(value="status") Integer var2);

    @Modifying
    @Query(value="UPDATE ShopPo SET deliveryName = :deliveryName WHERE id = :shopId")
    public void updateDeliveryName(@Param(value="shopId") Long var1, @Param(value="deliveryName") String var2);

    @Modifying
    @Query(value="UPDATE ShopPo SET mobile = :mobile WHERE id = :id")
    public void updateShopPoMobile(@Param(value="id") Long var1, @Param(value="mobile") String var2);

    public List<ShopPo> findByDepotId(String var1);

    public List<ShopPo> findByAssartDepotId(String var1);

    public List<ShopPo> findByIdIn(Set<Long> var1);

    @Query(value="SELECT id FROM ShopPo WHERE businessLicenceId = :businessLicenceId AND id != :shopId")
    public List<Long> findShopIdBybusinessLicenceId(@Param(value="businessLicenceId") String var1, @Param(value="shopId") Long var2);

    @Query(value="From ShopPo Where createTime between :startTime and :endTime order by createTime")
    public List<ShopPo> findByStartTimeAndEndTime(@Param(value="startTime") Timestamp var1, @Param(value="endTime") Timestamp var2);

    @Query(value="From ShopPo where inviterCode=?1 AND status = 9 and detailAuditStatus = 30")
    public List<ShopPo> findshopByInviterCode(String var1);

    @Query(value="FROM ShopPo where id=?1 AND status = 9 and detailAuditStatus = 30")
    public ShopPo findShopByIdPass(Long var1);

    @Query(value="From ShopPo s where s.detailAuditStatus = 30 AND s.status = 9")
    public List<ShopPo> findShopPoAndPass();

    @Query(value="FROM ShopPo s where s.detailAuditStatus = 30 AND s.status = 9 AND s.mobile = ?1")
    public ShopPo findShopPoByMobileAndPass(String var1);

    @Query(value="From ShopPo s where s.detailAuditStatus = 30 and s.id !=?1 and s.status = 9")
    public List<ShopPo> findShopsExit(Long var1);

    @Query(value="From ShopPo s where s.detailAuditStatus = 30 and s.shopType.id=52 and s.status = 9 ")
    public List<ShopPo> findCityShopsAndPass();

    @Query(value="From ShopPo s where s.detailAuditStatus = 30 and s.shopType.id=52 and s.status = 9 and s.id = ?1")
    public ShopPo findCityShopAndPass(Long var1);

    public List<ShopPo> findByShopTypeId(Long var1);

    @Query(value="FROM ShopPo s WHERE s.shopType.id = ?1 AND s.createTime >= ?2 AND s.createTime < ?3")
    public List<ShopPo> findByShopTypeIdAndStartTimeAndEndTime(Long var1, Timestamp var2, Timestamp var3);

    @Query(value="FROM ShopPo s WHERE s.mobile = :mobile AND s.id != :shopId")
    public List<ShopPo> findShopPoByMobileAndHaveNotShopId(@Param(value="mobile") String var1, @Param(value="shopId") Long var2);

    public List<ShopPo> findById(@Param(value="id") List<Long> var1);

    @Query(value="From ShopPo s WHERE s.detailAuditStatus = :auditStatus AND s.qualificationAuditStatus = :auditStatus order by s.createTime desc")
    public List<ShopPo> findByAuditStatus(@Param(value="auditStatus") Integer var1);

    public List<ShopPo> findShopPoByCityId(Integer var1);

    public List<ShopPo> findShopPoByCityShopId(Long var1);

    public List<ShopPo> findShopPoByCityShopId(Long var1, Sort var2);
}

