/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.mysql.shop;

import com.depotnearby.common.dao.mysql.CommonManageAbleDao;
import com.depotnearby.common.po.product.SaleAreaPo;
import com.depotnearby.common.po.shop.ShopPo;
import com.depotnearby.common.po.tag.BusinessTagPo;
import com.depotnearby.common.po.tag.PriceTagPo;
import com.depotnearby.common.vo.search.SearchShopReqVo;
import com.depotnearby.common.vo.search.ShopQueryReqVo;
import com.depotnearby.common.vo.shop.ShopExportVo;
import com.depotnearby.common.vo.shop.ShopRankVo;
import com.depotnearby.common.vo.shop.ShopsInfoExportVo;
import com.depotnearby.dao.mysql.shop.ShopDao;
import com.depotnearby.dao.mysql.shop.ShopPoRepository;
import com.depotnearby.dao.mysql.shop.ShopTypeRepository;
import com.depotnearby.util.DateTool;
import com.depotnearby.vo.statistic.DailyStatNewShopResultVo;
import com.depotnearby.vo.statistic.ShopAuditStatisticResultVo;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.codelogger.utils.ValueUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Repository;

@Repository(value="shopRepositoryImp")
public class ShopRepositoryImpl
extends CommonManageAbleDao
implements ShopDao {
    @Autowired
    ShopTypeRepository shopTypeRepository;
    @Autowired
    ShopPoRepository shopPoRepository;

    @Override
    public List<ShopPo> searchShops(SearchShopReqVo vo) {
        int i;
        CriteriaBuilder.In in;
        ListJoin t;
        List<Integer> iterator;
        Metamodel m;
        ArrayList<Object> predicates = new ArrayList<Object>();
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery criteriaQuery = cb.createQuery(ShopPo.class);
        Root root = criteriaQuery.from(ShopPo.class);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{vo.getMobile()})) {
            predicates.add(cb.equal((Expression)root.get("mobile"), (Object)vo.getMobile()));
        }
        if (CollectionUtils.isNotEmpty(vo.getShopTypes())) {
            List<Integer> iterator2 = vo.getShopTypes();
            CriteriaBuilder.In in2 = cb.in((Expression)root.get("shopType"));
            for (int i2 = 0; i2 < iterator2.size(); ++i2) {
                in2.value((Object)iterator2.get(i2));
            }
            predicates.add(in2);
        }
        if (CollectionUtils.isNotEmpty(vo.getSaleAreas())) {
            m = this.getEntityManager().getMetamodel();
            iterator = vo.getSaleAreas();
            EntityType shop = m.entity(ShopPo.class);
            t = root.join(shop.getList("saleAreas", SaleAreaPo.class));
            in = cb.in((Expression)t.get("id"));
            for (i = 0; i < iterator.size(); ++i) {
                in.value((Object)iterator.get(i));
            }
            predicates.add(in);
        }
        if (CollectionUtils.isNotEmpty(vo.getPriceTags())) {
            m = this.getEntityManager().getMetamodel();
            iterator = vo.getPriceTags();
            EntityType shop = m.entity(ShopPo.class);
            t = root.join(shop.getList("priceTags", PriceTagPo.class));
            in = cb.in((Expression)t.get("id"));
            for (i = 0; i < iterator.size(); ++i) {
                in.value((Object)iterator.get(i));
            }
            predicates.add(in);
        }
        if (CollectionUtils.isNotEmpty(vo.getBusinessTags())) {
            m = this.getEntityManager().getMetamodel();
            iterator = vo.getBusinessTags();
            EntityType shop = m.entity(ShopPo.class);
            t = root.join(shop.getList("businessTags", BusinessTagPo.class));
            in = cb.in((Expression)t.get("id"));
            for (i = 0; i < iterator.size(); ++i) {
                in.value((Object)iterator.get(i));
            }
            predicates.add(in);
        }
        if (ValueUtils.getValue((Integer)vo.getDistrictId()) != 0) {
            predicates.add(cb.equal((Expression)root.get("district"), (Object)vo.getDistrictId()));
        } else if (ValueUtils.getValue((Integer)vo.getCityId()) != 0) {
            predicates.add(cb.equal((Expression)root.get("city"), (Object)vo.getCityId()));
        } else if (ValueUtils.getValue((Integer)vo.getProvinceId()) != 0) {
            predicates.add(cb.equal((Expression)root.get("province"), (Object)vo.getProvinceId()));
        }
        criteriaQuery.where(predicates.toArray(new Predicate[0]));
        TypedQuery q = this.getEntityManager().createQuery(criteriaQuery);
        List result = q.getResultList();
        return result;
    }

    @Override
    public Long findMaxUserId() {
        Query query = this.getEntityManager().createQuery("SELECT id FROM ShopPo ORDER BY id DESC");
        try {
            Object id = query.setMaxResults(1).getSingleResult();
            return id == null ? 0L : Long.valueOf(id.toString());
        }
        catch (NoResultException e) {
            return 0L;
        }
    }

    @Override
    public Page<ShopPo> searchPageShops(final ShopQueryReqVo vo, Pageable pageable) {
        return this.shopPoRepository.findAll((Specification)new Specification<ShopPo>(){

            public Predicate toPredicate(Root<ShopPo> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                int i;
                CriteriaBuilder.In in;
                ListJoin t;
                List<Integer> iterator;
                Metamodel m;
                int i2;
                CriteriaBuilder.In in2;
                List<Integer> iterator2;
                ArrayList<Object> predicates = new ArrayList<Object>();
                if (ValueUtils.getValue((Long)vo.getId()) != 0L) {
                    predicates.add(cb.equal((Expression)root.get("id"), (Object)vo.getId()));
                }
                if (vo.getDetailAuditStatus() != null && vo.getDetailAuditStatus() != -1) {
                    predicates.add(cb.equal((Expression)root.get("detailAuditStatus"), (Object)vo.getDetailAuditStatus()));
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{vo.getMobile()})) {
                    predicates.add(cb.equal((Expression)root.get("mobile"), (Object)vo.getMobile()));
                }
                if (CollectionUtils.isNotEmpty(vo.getShopTypes())) {
                    iterator2 = vo.getShopTypes();
                    in2 = cb.in((Expression)root.get("shopType"));
                    for (i2 = 0; i2 < iterator2.size(); ++i2) {
                        in2.value((Object)iterator2.get(i2));
                    }
                    predicates.add(in2);
                }
                if (CollectionUtils.isNotEmpty(vo.getSaleAreas())) {
                    iterator2 = vo.getSaleAreas();
                    in2 = cb.in((Expression)root.get("saleAreaId"));
                    for (i2 = 0; i2 < iterator2.size(); ++i2) {
                        in2.value((Object)iterator2.get(i2));
                    }
                    predicates.add(in2);
                }
                if (CollectionUtils.isNotEmpty(vo.getPriceTags())) {
                    m = ShopRepositoryImpl.this.getEntityManager().getMetamodel();
                    iterator = vo.getPriceTags();
                    EntityType shop = m.entity(ShopPo.class);
                    t = root.join(shop.getList("priceTags", PriceTagPo.class));
                    in = cb.in((Expression)t.get("id"));
                    for (i = 0; i < iterator.size(); ++i) {
                        in.value((Object)iterator.get(i));
                    }
                    predicates.add(in);
                }
                if (CollectionUtils.isNotEmpty(vo.getBusinessTags())) {
                    m = ShopRepositoryImpl.this.getEntityManager().getMetamodel();
                    iterator = vo.getBusinessTags();
                    EntityType shop = m.entity(ShopPo.class);
                    t = root.join(shop.getList("businessTags", BusinessTagPo.class));
                    in = cb.in((Expression)t.get("id"));
                    for (i = 0; i < iterator.size(); ++i) {
                        in.value((Object)iterator.get(i));
                    }
                    predicates.add(in);
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getBusinessLicenceId())) {
                    predicates.add(cb.like((Expression)root.get("businessLicenceId"), new StringBuffer().append(vo.getBusinessLicenceId()).append("%").toString()));
                }
                if (ValueUtils.getValue((Integer)vo.getDistrictId()) != 0) {
                    predicates.add(cb.equal((Expression)root.get("district"), (Object)vo.getDistrictId()));
                } else if (ValueUtils.getValue((Integer)vo.getCityId()) != 0) {
                    predicates.add(cb.equal((Expression)root.get("city"), (Object)vo.getCityId()));
                } else if (ValueUtils.getValue((Integer)vo.getProvinceId()) != 0) {
                    predicates.add(cb.equal((Expression)root.get("province"), (Object)vo.getProvinceId()));
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getDepotId())) {
                    predicates.add(cb.equal((Expression)root.get("depot").get("id"), (Object)vo.getDepotId()));
                }
                if (ValueUtils.getValue((Integer)vo.getDepotType()) != 0) {
                    predicates.add(cb.equal((Expression)root.get("depot").get("depotType"), (Object)vo.getDepotType()));
                }
                if (ValueUtils.getValue((Long)vo.getCompanyId()) != 0L) {
                    predicates.add(cb.equal((Expression)root.get("depot").get("company").get("id"), (Object)vo.getCompanyId()));
                }
                return cb.and(predicates.toArray(new Predicate[predicates.size()]));
            }
        }, pageable);
    }

    @Override
    public List<ShopExportVo> findShopInfoByStartTimeAndEndTime(String startTime, String endTime) {
        if (StringUtils.isNotEmpty((CharSequence)startTime)) {
            startTime = "0000-00-00 00:00:00";
        }
        Object a = null;
        if (StringUtils.isNotEmpty((CharSequence)endTime)) {
            endTime = DateTool.nowTimestamp().toString();
        }
        String sqlStr = "select s.mobile,s.name , s.createTime , s.qualificationAuditStatus ,s.inviterCode, de.name , gp.name  from ShopPo s left join DepotEmployeePo de on s.invitercode = de.id left join ProvincePo gp on s.provinceId = gp.id where s.createTime >='" + startTime + "' and s.createTime <='" + endTime + "' order by s.createTime desc";
        Query query = this.getEntityManager().createQuery(sqlStr);
        try {
            List result = query.getResultList();
            return result;
        }
        catch (NoResultException e) {
            return new ArrayList<ShopExportVo>();
        }
    }

    @Override
    public List<ShopAuditStatisticResultVo> findShopAuditStatisticBy(Timestamp endTime, Map<String, Object> searchParams) {
        StringBuilder sb = new StringBuilder();
        if (searchParams.get("provinceId") != null) {
            sb.append(" AND sp.provinceId = :provinceId");
        }
        if (searchParams.get("depotId") != null && StringUtils.isNotBlank((CharSequence)searchParams.get("depotId").toString())) {
            sb.append(" AND sp.assartDepotId = :depotId");
        }
        String sql = "SELECT gp.id AS province_id,\n       gp.name AS province_name,\n       dt.name AS depot_name,\n       SUM(CASE\n         WHEN sp.qualificationauditstatus = '10' THEN 1\n         ELSE 0\n       END) AS register_not_complete,\n       SUM(CASE\n         WHEN sp.qualificationauditstatus < '10' THEN 1\n         ELSE 0\n       END) AS audit_not_pass,\n       SUM(CASE\n         WHEN sp.qualificationauditstatus <= '30' AND  sp.qualificationauditstatus >= '20' THEN 1\n         ELSE 0\n       END) AS audit_pass\nFROM shop sp\nLEFT JOIN geo_province gp ON gp.id = sp.provinceId\nLEFT JOIN depot dt ON sp.assartDepotId = dt.id\nWHERE sp.createtime <= :endTime\n %s GROUP BY province_id, province_name, depot_name\n";
        Query query = this.getEntityManager().createNativeQuery(String.format(sql, sb.toString()), "ShopAuditStatisticBinding");
        query.setParameter("endTime", (Object)endTime);
        if (searchParams.get("provinceId") != null) {
            query.setParameter("provinceId", searchParams.get("provinceId"));
        }
        if (searchParams.get("depotId") != null && StringUtils.isNotBlank((CharSequence)searchParams.get("depotId").toString())) {
            query.setParameter("depotId", searchParams.get("depotId"));
        }
        return query.getResultList();
    }

    @Override
    public List<DailyStatNewShopResultVo> findDailyNewShopCountBy(String startTime, String endTime) {
        String sql = "SELECT date_format(sp.createtime, '%Y-%m-%d') AS d_day,\n\tsp.provinceId AS province_id,\n\tsp.shopTypeId AS shop_type_id,\n\tCOUNT(sp.id) AS day_new_shop_count\nFROM shop sp\nWHERE sp.createtime >= :startTime\nAND sp.createtime <= :endTime\nAND sp.qualificationauditstatus > '20'\nGROUP BY d_day, province_id, shop_type_id";
        Query query = this.getEntityManager().createNativeQuery(sql, "DailyNewShopBinding");
        query.setParameter("startTime", (Object)startTime).setParameter("endTime", (Object)endTime);
        return query.getResultList();
    }

    @Override
    public int getShopCountBy(String provinceName, Long shopTypeId, Timestamp endTime) {
        String baseSql = "SELECT \n    COUNT(*) AS shop_count\nFROM shop sp\nLEFT JOIN shop_type st ON sp.shopTypeId = st.id\nLEFT JOIN geo_province gp ON gp.id = sp.provinceId\nWHERE sp.qualificationAuditStatus > 20\nAND sp.createtime <= :endTime\n";
        StringBuilder sb = new StringBuilder();
        if (provinceName == null) {
            sb.append("AND gp.name IS NULL\n");
        } else {
            sb.append("AND gp.name = :provinceName\n");
        }
        if (shopTypeId == null) {
            sb.append("AND st.id IS NULL\n");
        } else {
            sb.append("AND st.id = :shopTypeId\n");
        }
        String sql = baseSql.concat(sb.toString());
        Query query = this.getEntityManager().createNativeQuery(sql).setParameter("endTime", (Object)endTime);
        if (provinceName != null) {
            query.setParameter("provinceName", (Object)provinceName);
        }
        if (shopTypeId != null) {
            query.setParameter("shopTypeId", (Object)shopTypeId);
        }
        return ((Number)query.getSingleResult()).intValue();
    }

    @Override
    public List<ShopsInfoExportVo> findShopsInfoBetween(Timestamp startTime, Timestamp endTime) {
        String sql = "SELECT\n    sp.id AS 'shop_id',\n    usr.mobile AS 'user_mobile',\n    st.name AS 'shop_type',\n    gp.name AS 'shop_province',\n    usr.createtime AS 'user_register_time',\n    usr.lastlogintime AS 'user_lastlogintime',\n    CASE \n        WHEN sp.qualificationauditstatus = '0' THEN '\u5ba1\u6838\u672a\u901a\u8fc7'\n        WHEN sp.qualificationauditstatus = '5' THEN '\u5ba1\u6838\u8d44\u6599\u5df2\u8fc7\u671f'\n        WHEN sp.qualificationauditstatus = '10' THEN '\u7b49\u5f85\u4e0a\u4f20\u8d44\u6599'\n        WHEN sp.qualificationauditstatus = '20' THEN '\u7b49\u5f85\u5ba1\u6838'\n        WHEN sp.qualificationauditstatus = '23' THEN '\u539f\u8d44\u6599\u751f\u6548\uff0c\u65b0\u7684\u8be6\u7ec6\u8d44\u6599\u5ba1\u6838\u5931\u8d25'\n        WHEN sp.qualificationauditstatus = '25' THEN '\u539f\u8d44\u6599\u751f\u6548\uff0c\u5e76\u5df2\u63d0\u4ea4\u65b0\u7684\u8d44\u6599\uff0c\u7b49\u5f85\u9a8c\u8bc1'\n        WHEN sp.qualificationauditstatus = '30' THEN '\u5ba1\u6838\u901a\u8fc7'\n    END AS 'shop_status',\n    sp.invitercode AS 'shop_invite_code',\n    de.name AS 'shop_inviter_name',\n    ad.name AS 'shop_assart_depot_name',\n    pd.name AS 'shop_price_depot_name',\n    dd.name AS 'shop_deliver_depot_name',\n    sp.name AS 'shop_name',\n    gp.name AS 'province_name',\n    gc.name AS 'city_name',\n    gd.name AS 'district_name',\n    sp.shopaddress AS 'shop_address'\nFROM usr_user usr\nLEFT JOIN shop sp ON usr.shopId = sp.id\nLEFT JOIN shop_type st ON st.id = sp.shopTypeId \nLEFT JOIN depot_employee de ON de.id = sp.invitercode\nLEFT JOIN depot ad ON sp.assartDepotId = ad.id\nLEFT JOIN depot pd ON sp.depotId = pd.id\nLEFT JOIN depot dd ON sp.deliveryDepotId = dd.id\nLEFT JOIN geo_province gp ON gp.id = sp.provinceId\nLEFT JOIN geo_city gc ON gc.id = sp.cityId\nLEFT JOIN geo_district gd ON gd.id = sp.districtId\nWHERE usr.createtime >= :startTime\nAND usr.createtime <= :endTime\nORDER BY usr.createtime DESC";
        Query query = this.getEntityManager().createNativeQuery(sql, "shopsInfo");
        query.setParameter("startTime", (Object)startTime).setParameter("endTime", (Object)endTime);
        return query.getResultList();
    }

    @Override
    public List<ShopRankVo> findShopRankEditVos() {
        StringBuilder str = new StringBuilder();
        str.append("select s1.id id , s1.name name, s1.growthvalue growthValue ,s2.scalename rank from shop s1 LEFT JOIN  scale s2 on s1.growthvalue BETWEEN s2.startvalue and s2.endvalue ");
        Query query = this.getEntityManager().createNativeQuery(str.toString(), "ShopRankVo");
        return query.getResultList();
    }
}

