/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.mysql.statistic;

import com.depotnearby.common.dao.mysql.CommonManageAbleDao;
import com.depotnearby.dao.mysql.statistic.DailyStatRecordDao;
import com.depotnearby.vo.statistic.MonthlyStatsResultVo;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository(value="dailyStatRecordRepositoryImpl")
public class DailyStatRecordRepositoryImpl
extends CommonManageAbleDao
implements DailyStatRecordDao {
    @Override
    public List<MonthlyStatsResultVo> findMonthlyStatsResultBy(Map<String, Object> searchParams) throws ParseException {
        String monthStartDay = (String)searchParams.get("monthStartDay");
        String monthEndDay = (String)searchParams.get("monthEndDay");
        String sql = "SELECT\n    date_format(str_to_date(dr.`dday`, '%Y-%m-%d'), '%Y-%m') AS time,\n    gp.name AS province_name,\n    st.id AS shop_type_id,\n    st.name AS shop_type_name,\n    SUM(dr.`dayordercount`) AS order_count,\n    SUM(dr.`saleamount`) AS order_amount\nFROM `daily_stat_record` dr\nLEFT JOIN `shop_type` st ON dr.shoptypeid = st.id\nLEFT JOIN `geo_province` gp ON dr.provinceid = gp.id\nWHERE dr.`dday` >= :startTime\nAND dr.`dday` <= :endTime\n%whereCondition%\nGROUP BY time, province_name, shop_type_id, shop_type_name";
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)((String)searchParams.get("provinceId")))) {
            sb.append("AND gp.id = :provinceId\n");
        }
        if (StringUtils.isNotBlank((CharSequence)((String)searchParams.get("shopTypeId")))) {
            sb.append("AND st.id = :shopTypeId\n");
        }
        Query query = this.getEntityManager().createNativeQuery(sql.replace("%whereCondition%", sb.toString()), "MonthlyStatResultBinding");
        query.setParameter("startTime", (Object)monthStartDay);
        query.setParameter("endTime", (Object)monthEndDay);
        if (StringUtils.isNotBlank((CharSequence)((String)searchParams.get("provinceId")))) {
            query.setParameter("provinceId", (Object)StringUtils.trim((String)((String)searchParams.get("provinceId"))));
        }
        if (StringUtils.isNotBlank((CharSequence)((String)searchParams.get("shopTypeId")))) {
            query.setParameter("shopTypeId", (Object)StringUtils.trim((String)((String)searchParams.get("shopTypeId"))));
        }
        return query.getResultList();
    }
}

