/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.mysql.user;

import com.depotnearby.common.po.user.UserPo;
import com.depotnearby.dao.mysql.user.UserDao;
import java.sql.Timestamp;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface UserRepository
extends JpaRepository<UserPo, Long>,
UserDao {
    public UserPo findByMobile(String var1);

    public UserPo findByAccount(String var1);

    @Modifying
    @Query(value="update UserPo u set u.password = :password,u.originalPassword = :originalPassword  where u.mobile = :mobile")
    public void updateUserPassword(@Param(value="mobile") String var1, @Param(value="password") String var2, @Param(value="originalPassword") String var3);

    public List<UserPo> findByShopId(Long var1);

    @Modifying
    @Query(value="UPDATE UserPo SET status = 0 WHERE id = :id")
    public void disableUser(@Param(value="id") Long var1);

    @Query(value="SELECT id FROM UserPo")
    public List<Long> findAllUserIds();

    @Query(value="SELECT id FROM UserPo u WHERE u.shop.province.id = :provinceId")
    public List<Long> findUserIdsByProvince(@Param(value="provinceId") Integer var1);

    @Query(value="SELECT id FROM UserPo u WHERE u.shop.city.id = :cityId")
    public List<Long> findUserIdsByCity(@Param(value="cityId") Integer var1);

    @Query(value="SELECT id FROM UserPo u WHERE u.shop.district.id = :districtId")
    public List<Long> findUserIdsByDistrict(@Param(value="districtId") Integer var1);

    @Query(value="SELECT id FROM UserPo u WHERE u.shop.shopType.id = :shopTypeId")
    public List<Long> findUserIdsByShopType(@Param(value="shopTypeId") Long var1);

    @Query(value="SELECT id FROM UserPo u WHERE u.shop.id = :shopId")
    public List<Long> findUserIdsByShopId(@Param(value="shopId") Long var1);

    @Query(value="FROM UserPo u WHERE u.shop.id = :shopId")
    public List<UserPo> findUserByShopId(@Param(value="shopId") Long var1);

    @Query(value="SELECT id FROM UserPo u WHERE u.shop.province.id = :provinceId AND u.shop.shopType.id = :shopTypeId")
    public List<Long> findUserIdsByProvinceAndShopType(@Param(value="provinceId") Integer var1, @Param(value="shopTypeId") Integer var2);

    @Query(value="SELECT id FROM UserPo u WHERE u.shop.city.id = :cityId AND u.shop.shopType.id = :shopTypeId")
    public List<Long> findUserIdsByCityAndShopType(@Param(value="cityId") Integer var1, @Param(value="shopTypeId") Integer var2);

    @Query(value="SELECT id FROM UserPo u WHERE u.shop.district.id = :districtId AND u.shop.shopType.id = :shopTypeId")
    public List<Long> findUserIdsByDistrictAndShopType(@Param(value="districtId") Integer var1, @Param(value="shopTypeId") Integer var2);

    @Modifying
    @Query(value="UPDATE UserPo SET mobile = :mobile , account = :mobile WHERE id = :id")
    public void updateUserMobile(@Param(value="id") Long var1, @Param(value="mobile") String var2);

    @Modifying
    @Query(value="UPDATE UserPo SET avatar = :avatar WHERE id = :id")
    public void updateUserAvatar(@Param(value="id") Long var1, @Param(value="avatar") String var2);

    @Modifying
    @Query(value="UPDATE UserPo SET lastLoginDeviceToken = :lastLoginDeviceToken, lastLoginTime = :lastLoginTime, lastLoginIP = :lastLoginIP WHERE id = :userId")
    public void updateUserLatestLoginInfo(@Param(value="userId") Long var1, @Param(value="lastLoginDeviceToken") String var2, @Param(value="lastLoginTime") Timestamp var3, @Param(value="lastLoginIP") String var4);

    @Modifying
    @Query(value="UPDATE UserPo SET lastLoginDeviceToken = null WHERE id = :userId")
    public void cleanLoginDevice(@Param(value="userId") Long var1);

    @Modifying
    @Query(value="Update UserPo Set status=:status where id=:id")
    public void updateUserStatusById(@Param(value="id") Long var1, @Param(value="status") Integer var2);

    @Query(value="SELECT u.id FROM UserPo u INNER JOIN u.shop s WHERE s.saleAreaId = :saleAreaId")
    public List<Long> findUserIdsBySaleAreaId(@Param(value="saleAreaId") Integer var1);

    @Query(value="SELECT id FROM UserPo u WHERE u.shop.id = :shopId and u.isAdmin = :isAdmin ORDER BY id DESC")
    public List<Long> findUserIdByShopIdAndAdminStatus(@Param(value="shopId") Long var1, @Param(value="isAdmin") Boolean var2);

    public List<UserPo> findByOldIdIsNull();

    @Query(value="SELECT u.id FROM UserPo u WHERE u.shop.detailAuditStatus = :auditStatus AND u.shop.qualificationAuditStatus = :auditStatus")
    public List<Long> findAllUserIds(@Param(value="auditStatus") Integer var1);

    @Query(value="FROM UserPo u WHERE u.shop.detailAuditStatus = :auditStatus AND u.shop.qualificationAuditStatus = :auditStatus")
    public List<UserPo> findAllUserByAuditStatus(@Param(value="auditStatus") Integer var1);

    @Query(value="FROM UserPo u WHERE u.shop.id = :shopId and u.isAdmin = :isAdmin ORDER BY id DESC")
    public List<UserPo> findUsersByShopIdAndAdminStatus(@Param(value="shopId") Long var1, @Param(value="isAdmin") Boolean var2);

    @Query(value="FROM UserPo u WHERE u.shop.detailAuditStatus = :auditStatus AND u.shop.qualificationAuditStatus = :auditStatus order by u.createTime desc")
    public List<UserPo> findAllUserByAuditStatusTwo(@Param(value="auditStatus") Integer var1);

    public UserPo findByWechatOpenId(String var1);

    @Modifying
    @Query(value="UPDATE UserPo SET wechatOpenId = null WHERE wechatOpenId = :wechatOpenId")
    public void clearUserWechatOpenId(@Param(value="wechatOpenId") String var1);
}

