/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.mysql.user;

import com.depotnearby.common.dao.mysql.CommonManageAbleDao;
import com.depotnearby.common.po.user.UserPo;
import com.depotnearby.common.vo.search.SearchUserReqVo;
import com.depotnearby.dao.mysql.user.UserDao;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository(value="userRepositoryImp")
public class UserRepositoryImpl
extends CommonManageAbleDao
implements UserDao {
    @Override
    public List<UserPo> searchUser(SearchUserReqVo vo) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        CriteriaBuilder cb = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery criteriaQuery = cb.createQuery(UserPo.class);
        Root form = criteriaQuery.from(UserPo.class);
        if (StringUtils.isNotEmpty((CharSequence)vo.getMobile())) {
            predicates.add(cb.equal((Expression)form.get("mobile"), (Object)vo.getMobile()));
        } else if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{vo.getAccount()})) {
            predicates.add(cb.like((Expression)form.get("account"), "%" + vo.getAccount() + "%"));
        }
        criteriaQuery.where(predicates.toArray(new Predicate[0]));
        TypedQuery q = this.getEntityManager().createQuery(criteriaQuery);
        List result = q.getResultList();
        return result;
    }

    @Override
    public Long findMaxUserId() {
        Query query = this.getEntityManager().createQuery("SELECT id FROM UserPo ORDER BY id DESC");
        try {
            Object id = query.setMaxResults(1).getSingleResult();
            return id == null ? 0L : Long.valueOf(id.toString());
        }
        catch (NoResultException e) {
            return 0L;
        }
    }
}

