/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.mysql.voucher;

import com.depotnearby.common.dao.mysql.CommonManageAbleDao;
import com.depotnearby.common.po.voucher.VoucherConstant;
import com.depotnearby.common.po.voucher.VoucherPo;
import com.depotnearby.dao.mysql.voucher.VoucherDao;
import com.depotnearby.vo.statistic.UserVoucherStatisticResultVo;
import java.util.List;
import java.util.Map;
import javax.persistence.Query;
import org.springframework.stereotype.Repository;

@Repository(value="voucherRepositoryImpl")
public class VoucherRepositoryImpl
extends CommonManageAbleDao
implements VoucherDao {
    @Override
    public Map<VoucherConstant.VoucherUseStatus, List<VoucherPo>> listVoucherByUseStatus(int userId) {
        return null;
    }

    @Override
    public List<UserVoucherStatisticResultVo> findAllUserVouchers(Map<String, Object> searchParams) {
        String sql = "SELECT \n    vv.bindingtime AS time,\n    ur.mobile AS user_mobile,\n    ur.id AS user_id,\n    gp.name AS province_name,\n    st.name AS shop_type_name,\n    vt.name AS voucher_type_name,\n    vt.id AS voucher_type_id,\n    vt.issuecount AS voucher_issue_count\nFROM vou_voucher vv\nLEFT JOIN usr_user ur ON vv.bindinguserid = ur.id\nLEFT JOIN shop sp ON ur.shopId = sp.id\nLEFT JOIN shop_type st ON sp.shopTypeId = st.id\nLEFT JOIN geo_province gp ON sp.provinceId = gp.id\nLEFT JOIN vou_type vt ON vt.id = vv.voucherTypeId\nWHERE 1 = 1\n";
        StringBuilder sb = new StringBuilder();
        if (searchParams.get("startTime") != null) {
            sb.append("AND vv.bindingtime >= :startTime\n");
        }
        if (searchParams.get("endTime") != null) {
            sb.append("AND vv.bindingtime <= :endTime\n");
        }
        if (searchParams.get("provinceId") != null) {
            sb.append("AND gp.id = :provinceId\n");
        }
        if (searchParams.get("shopTypeId") != null) {
            sb.append("AND st.id = :shopTypeId\n");
        }
        if (searchParams.get("voucherTypeName") != null) {
            sb.append("AND vt.name = :voucherTypeName");
        }
        Query query = this.getEntityManager().createNativeQuery(sql.concat(sb.toString()), "UserVoucherStatsBinding");
        if (searchParams.get("startTime") != null) {
            query.setParameter("startTime", searchParams.get("startTime"));
        }
        if (searchParams.get("endTime") != null) {
            query.setParameter("endTime", searchParams.get("endTime"));
        }
        if (searchParams.get("provinceId") != null) {
            query.setParameter("provinceId", searchParams.get("provinceId"));
        }
        if (searchParams.get("shopTypeId") != null) {
            query.setParameter("shopTypeId", searchParams.get("shopTypeId"));
        }
        if (searchParams.get("voucherTypeName") != null) {
            query.setParameter("voucherTypeName", searchParams.get("voucherTypeName"));
        }
        return query.getResultList();
    }
}

