/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.mysql.ximu;

import com.depotnearby.common.dao.mysql.CommonManageAbleDao;
import com.depotnearby.common.po.ximu.XiMuLoanPo;
import com.depotnearby.common.vo.ximu.XimuQueryReqVo;
import com.depotnearby.dao.mysql.ximu.XiMuLoanDao;
import com.depotnearby.dao.mysql.ximu.XiMuLoanRepository;
import com.depotnearby.util.DateTool;
import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Repository;

@Repository
public class XiMuLoanRepositoryImpl
extends CommonManageAbleDao
implements XiMuLoanDao {
    @Autowired
    private XiMuLoanRepository loanRepository;

    @Override
    public Page<XiMuLoanPo> searchXiMuLoans(final XimuQueryReqVo vo, Pageable pageable) {
        return this.loanRepository.findAll((Specification)new Specification<XiMuLoanPo>(){

            public Predicate toPredicate(Root<XiMuLoanPo> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                ArrayList predicates = Lists.newArrayList();
                if (vo.getId() != null) {
                    predicates.add(cb.equal((Expression)root.get("id"), (Object)vo.getId()));
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getOrderCode())) {
                    predicates.add(cb.equal((Expression)root.get("order").get("orderCode"), (Object)vo.getOrderCode()));
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getUserMobile())) {
                    predicates.add(cb.equal((Expression)root.get("order").get("consignee").get("mobile"), (Object)vo.getUserMobile()));
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getXmListCode())) {
                    predicates.add(cb.equal((Expression)root.get("xmListCode"), (Object)vo.getXmListCode()));
                }
                if (vo.getStatus() != null) {
                    predicates.add(cb.equal((Expression)root.get("status"), (Object)vo.getStatus()));
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getFromTime())) {
                    Timestamp fromTime = DateTool.getTimestamp((String)vo.getFromTime(), (String)"yyyy-MM-dd");
                    predicates.add(cb.greaterThanOrEqualTo(root.get("createTime").as(Timestamp.class), (Comparable)fromTime));
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getEndTime())) {
                    Timestamp endTime = DateTool.getTimestamp((String)vo.getEndTime(), (String)"yyyy-MM-dd");
                    predicates.add(cb.lessThanOrEqualTo(root.get("createTime").as(Timestamp.class), (Comparable)endTime));
                }
                return cb.and(predicates.toArray(new Predicate[predicates.size()]));
            }
        }, pageable);
    }
}

