/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.redis;

import com.depotnearby.common.dao.redis.CommonRedisDao;
import com.depotnearby.common.ro.bean.RoConverter;
import com.depotnearby.common.ro.bean.RoKeyGenerator;
import com.depotnearby.common.util.RedisUtil;
import com.depotnearby.dao.Persistentable;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.codelogger.utils.ArrayUtils;

public abstract class AbstractRedisDao<T extends Persistentable<ID>, ID extends Serializable>
extends CommonRedisDao {
    private static final String SEPARATOR = ":";
    private Class<T> entityClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];

    public T save(T t) {
        this.hmset(RoKeyGenerator.getHashKey(this.entityClass, t.getId()), RoConverter.toMap(t));
        this.zadd(RoKeyGenerator.getIdSortedSetKey(this.entityClass), System.currentTimeMillis(), RedisUtil.toByteArray(t.getId()));
        return t;
    }

    public T findOne(ID id) {
        if (id == null) {
            return null;
        }
        return (T)((Persistentable)RoConverter.fromMap(this.hgetAll(RoKeyGenerator.getHashKey(this.entityClass, id)), this.entityClass));
    }

    public List<T> findByIds(Iterable<ID> ids) {
        if (ids == null || !ids.iterator().hasNext()) {
            return Lists.newArrayList();
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (Serializable id : ids) {
            keys.add(RoKeyGenerator.getHashKey(this.entityClass, (Serializable)id));
        }
        return this.findByKeys(keys);
    }

    public List<T> findAll() {
        Set<byte[]> idKeys = this.zRange(RoKeyGenerator.getIdSortedSetKey(this.entityClass), 0L, -1L);
        Object[] ids = RedisUtil.bytesSetToStringArray(idKeys);
        ArrayList entities = Lists.newArrayList();
        if (ArrayUtils.isNotEmpty((Object[])ids)) {
            ArrayList roHashKeys = Lists.newArrayList();
            for (Object id : ids) {
                roHashKeys.add(RoKeyGenerator.getHashKey(this.entityClass, (Serializable)id));
            }
            List roMaps = this.pipeHgetall(roHashKeys);
            for (Object roMap : roMaps) {
                entities.add(RoConverter.fromMap((Map)((Map)roMap), this.entityClass));
            }
        }
        return entities;
    }

    public void delete(ID id) {
        this.del(RoKeyGenerator.getHashKey(this.entityClass, id));
        this.zrem(RoKeyGenerator.getIdSortedSetKey(this.entityClass), id.toString());
    }

    public List<T> findByKeys(List<String> keys) {
        ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(keys)) {
            List list = this.pipeHgetall(keys);
            for (Object aList : list) {
                Map map = (Map)aList;
                if (map == null || map.isEmpty()) continue;
                result.add(RoConverter.fromMap((Map)map, this.entityClass));
            }
        }
        return result;
    }

    public String getKeyByParams(Object ... params) {
        StringBuilder key = new StringBuilder(RoKeyGenerator.getHashKeyPrefix(this.entityClass));
        if (params != null && params.length > 0) {
            for (Object param : params) {
                key.append(SEPARATOR).append(String.valueOf(param));
            }
        }
        return key.toString();
    }
}

