/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.redis;

import com.depotnearby.common.IdType;
import com.depotnearby.common.dao.redis.CommonRedisDao;
import com.depotnearby.common.ro.RedisKeyGenerator;
import com.depotnearby.common.util.RedisUtil;
import org.springframework.stereotype.Component;

@Component
public class IdRedisDao
extends CommonRedisDao {
    public long nextLongId(IdType idType) {
        byte[] nextId = this.lpop(RedisKeyGenerator.System.getIdPoolListKey(idType));
        return RedisUtil.byteArrayToLong((byte[])nextId);
    }

    public long remainCount(IdType idType) {
        return this.llen(RedisKeyGenerator.System.getIdPoolListKey(idType));
    }

    public void generatorLongIds(IdType idType, Long from, int size) {
        long[] arr = new long[size];
        for (int i = 0; i < size; ++i) {
            arr[i] = from + (long)i;
        }
        this.rpush(RedisKeyGenerator.System.getIdPoolListKey(idType), RedisUtil.toByteArray((long[])arr));
        this.hset(RedisKeyGenerator.System.getConfigHashKey(), idType.name(), RedisUtil.toByteArray((Long)(from + (long)size + 1L)));
    }

    public Number getFromNum(IdType idType, Long defaultFrom) {
        byte[] b = this.hget(RedisKeyGenerator.System.getConfigHashKey(), idType.name());
        if (b != null) {
            return RedisUtil.byteArrayToLong((byte[])b);
        }
        return defaultFrom;
    }
}

