/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.redis.adv;

import com.depotnearby.common.dao.redis.CommonRedisDao;
import com.depotnearby.common.ro.RedisKeyGenerator;
import com.depotnearby.common.ro.info.AdvRo;
import com.depotnearby.common.util.RedisUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.stereotype.Component;

@Component
public class AdvRedisDao
extends CommonRedisDao {
    public void save(AdvRo ro) {
        this.hmset(RedisKeyGenerator.Adv.getAdvHashKey(ro.getId()), ro.toMap());
        this.zadd(RedisKeyGenerator.Adv.getAllAdvSortSetKey(), ro.getStartTime().getTime(), RedisUtil.toByteArray((Long)ro.getId()));
    }

    public void delete(Long id) {
        this.del(RedisKeyGenerator.Adv.getAdvHashKey(id));
    }

    public AdvRo get(Long id) {
        if (id == null) {
            return null;
        }
        Map<byte[], byte[]> map = this.hgetAll(RedisKeyGenerator.Adv.getAdvHashKey(id));
        if (MapUtils.isNotEmpty(map)) {
            AdvRo ro = new AdvRo();
            ro.fromMap(map);
            return ro;
        }
        return null;
    }

    public List<AdvRo> findAll() {
        ArrayList<AdvRo> list = new ArrayList<AdvRo>();
        List ids = RedisUtil.stringSetToLongList(this.zrangeByScore(RedisKeyGenerator.Adv.getAllAdvSortSetKey(), "-inf", "+inf"));
        if (CollectionUtils.isNotEmpty((Collection)ids)) {
            for (Long id : ids) {
                AdvRo ro = this.get(id);
                if (ro == null) continue;
                list.add(ro);
            }
        }
        return list;
    }
}

