/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.redis.behaviour;

import com.depotnearby.common.dao.redis.CommonRedisDao;
import com.depotnearby.common.ro.RedisKeyGenerator;
import com.depotnearby.common.ro.behaviour.BehaviourLogRo;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class BehaviourRedisDao
extends CommonRedisDao {
    protected static final Logger logger = LoggerFactory.getLogger(BehaviourRedisDao.class);

    public void saveBehaviourLog(BehaviourLogRo ro) {
        this.rpush(RedisKeyGenerator.Product.getBehaviourLogQueueKey(), ro.toByte());
    }

    public List<BehaviourLogRo> dumpBehaviourLog(int size) {
        byte[] content;
        ArrayList<BehaviourLogRo> result = new ArrayList<BehaviourLogRo>(size);
        for (int i = 0; i < size && (content = this.lpop(RedisKeyGenerator.Product.getBehaviourLogQueueKey())) != null; ++i) {
            BehaviourLogRo ro = new BehaviourLogRo();
            try {
                ro.fromByte(content);
                result.add(ro);
                continue;
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        return result;
    }
}

