/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.redis.config;

import com.depotnearby.common.dao.redis.CommonRedisDao;
import com.depotnearby.common.ro.RedisKeyGenerator;
import com.depotnearby.common.ro.config.NavigationRo;
import com.depotnearby.common.util.RedisUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.stereotype.Component;

@Component
public class NavigationRedisDao
extends CommonRedisDao {
    public void save(NavigationRo ro) {
        this.zadd(RedisKeyGenerator.Navigation.getAllNavigationSortSetKey(), ro.getIdx().intValue(), RedisUtil.toByteArray((Long)ro.getId()));
        this.hmset(RedisKeyGenerator.Navigation.getNavigationHashKey(ro.getId()), ro.toMap());
    }

    public void delete(Long id) {
        this.zrem(RedisKeyGenerator.Navigation.getAllNavigationSortSetKey(), new byte[][]{RedisUtil.toByteArray((Long)id)});
        this.del(RedisKeyGenerator.Navigation.getNavigationHashKey(id));
    }

    public NavigationRo get(Long id) {
        if (id == null) {
            return null;
        }
        Map<byte[], byte[]> map = this.hgetAll(RedisKeyGenerator.Navigation.getNavigationHashKey(id));
        if (MapUtils.isNotEmpty(map)) {
            NavigationRo ro = new NavigationRo();
            ro.fromMap(map);
            return ro;
        }
        return null;
    }

    public List<NavigationRo> findAll() {
        ArrayList<NavigationRo> list = new ArrayList<NavigationRo>();
        List ids = RedisUtil.bytesSetToLongList(super.zRange(RedisKeyGenerator.Navigation.getAllNavigationSortSetKey(), 0L, -1L));
        if (CollectionUtils.isNotEmpty((Collection)ids)) {
            for (Long id : ids) {
                NavigationRo ro = this.get(id);
                if (ro == null) continue;
                list.add(ro);
            }
        }
        return list;
    }

    public Long getCount() {
        return this.zCard(RedisKeyGenerator.Navigation.getAllNavigationSortSetKey());
    }
}

