/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.redis.config;

import com.depotnearby.common.dao.redis.CommonRedisDao;
import com.depotnearby.common.ro.bean.RoConverter;
import com.depotnearby.common.ro.bean.RoKeyGenerator;
import com.depotnearby.common.ro.product.SpecialProductConfigRo;
import com.depotnearby.common.util.RedisUtil;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.codelogger.utils.ArrayUtils;
import org.springframework.stereotype.Component;

@Component
public class ProductConfigRedisDao
extends CommonRedisDao {
    public SpecialProductConfigRo saveSpecialProductConfig(SpecialProductConfigRo ro) {
        this.hmset(RoKeyGenerator.getHashKey(SpecialProductConfigRo.class, (Serializable)ro.getProductId()), RoConverter.toMap((Object)ro));
        this.zadd(RoKeyGenerator.getIdSortedSetKey(SpecialProductConfigRo.class), System.currentTimeMillis(), RedisUtil.toByteArray((Long)ro.getProductId()));
        return ro;
    }

    public SpecialProductConfigRo getSpecialProductConfig(Long productId) {
        if (productId == null) {
            return null;
        }
        return this.loadFromCacheOrCacheLoader("getSpecialProductConfig", new CacheLoader<String, SpecialProductConfigRo>(){

            public SpecialProductConfigRo load(String key) throws Exception {
                return (SpecialProductConfigRo)RoConverter.fromMap((Map)ProductConfigRedisDao.this.hgetAll(key), SpecialProductConfigRo.class);
            }
        }, RoKeyGenerator.getHashKey(SpecialProductConfigRo.class, (Serializable)productId), TimeUnit.SECONDS, 5L);
    }

    public void deleteSpecialProductConfig(Long productId) {
        if (productId == null) {
            return;
        }
        this.del(RoKeyGenerator.getHashKey(SpecialProductConfigRo.class, (Serializable)productId));
        this.zrem(RoKeyGenerator.getIdSortedSetKey(SpecialProductConfigRo.class), productId.toString());
    }

    public List<SpecialProductConfigRo> findAllSpecialProductConfig() {
        Set<byte[]> idKeys = this.zRange(RoKeyGenerator.getIdSortedSetKey(SpecialProductConfigRo.class), 0L, -1L);
        Object[] ids = RedisUtil.bytesSetToStringArray(idKeys);
        ArrayList ros = Lists.newArrayList();
        if (ArrayUtils.isNotEmpty((Object[])ids)) {
            ArrayList roHashKeys = Lists.newArrayList();
            for (Object id : ids) {
                roHashKeys.add(RoKeyGenerator.getHashKey(SpecialProductConfigRo.class, (Serializable)id));
            }
            List roMaps = this.pipeHgetall(roHashKeys);
            for (Object roMap : roMaps) {
                ros.add(RoConverter.fromMap((Map)((Map)roMap), SpecialProductConfigRo.class));
            }
        }
        return ros;
    }
}

