/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.redis.config;

import com.depotnearby.common.dao.redis.CommonRedisDao;
import com.depotnearby.common.ro.RedisKeyGenerator;
import com.depotnearby.common.ro.config.AppSideslipBarConfigRo;
import com.depotnearby.common.util.ExternalizationHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.codelogger.utils.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class SideslipBarRedisDao
extends CommonRedisDao {
    public void save(List<AppSideslipBarConfigRo> appSideslipBarConfigRos) {
        if (CollectionUtils.isEmpty(appSideslipBarConfigRos)) {
            return;
        }
        this.del(RedisKeyGenerator.AppConfig.getSidesliBarConfigHashKey());
        Collections.sort(appSideslipBarConfigRos);
        for (AppSideslipBarConfigRo appSideslipBarConfigRo : appSideslipBarConfigRos) {
            this.lpush(RedisKeyGenerator.AppConfig.getSidesliBarConfigHashKey(), new byte[][]{ExternalizationHelper.serialize(appSideslipBarConfigRo)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(AppSideslipBarConfigRo appSideslipBarConfigRo) {
        List<AppSideslipBarConfigRo> appSideslipBarConfigRos = this.get();
        for (AppSideslipBarConfigRo ro : appSideslipBarConfigRos) {
            if (!ro.getId().equals(appSideslipBarConfigRo.getId())) continue;
            String color = appSideslipBarConfigRo.getColor();
            String icon = appSideslipBarConfigRo.getIcon();
            String name = appSideslipBarConfigRo.getName();
            ro.setColor(StringUtils.isBlank((String)color) ? ro.getColor() : color);
            ro.setIcon(StringUtils.isBlank((String)icon) ? ro.getIcon() : icon);
            ro.setName(StringUtils.isBlank((String)name) ? ro.getName() : name);
            ro.setSortNumber(appSideslipBarConfigRo.getSortNumber());
            break;
        }
        SideslipBarRedisDao sideslipBarRedisDao = this;
        synchronized (sideslipBarRedisDao) {
            this.save(appSideslipBarConfigRos);
        }
    }

    public List<AppSideslipBarConfigRo> get() {
        List<byte[]> sidesliBars = this.lrange(RedisKeyGenerator.AppConfig.getSidesliBarConfigHashKey(), 0L, -1L);
        ArrayList<AppSideslipBarConfigRo> appSideslipBarConfigRos = new ArrayList<AppSideslipBarConfigRo>();
        if (CollectionUtils.isNotEmpty(sidesliBars)) {
            for (byte[] sidesliBar : sidesliBars) {
                AppSideslipBarConfigRo appSideslipBarConfigRo = (AppSideslipBarConfigRo)ExternalizationHelper.deserialize(new AppSideslipBarConfigRo(), sidesliBar);
                appSideslipBarConfigRos.add(appSideslipBarConfigRo);
            }
        }
        return appSideslipBarConfigRos;
    }
}

